/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.service;

import bsh.EvalError;
import cz.kpsys.AppServerStatus;
import cz.kpsys.db.BeanHandlers;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache;
import cz.kpsys.db.DbCache2;
import cz.kpsys.db.DbConfig;
import cz.kpsys.db.DbCore2;
import cz.kpsys.db.KPSYSBeanListHandler;
import cz.kpsys.db.ProxoolUtil;
import cz.kpsys.db.QueryRunnerOpened;
import cz.kpsys.db.RecordReconstructor2;
import cz.kpsys.db.ScalaRunnerOpened;
import cz.kpsys.db.model.LuceneField;
import cz.kpsys.db.model.v2.CentralPropoj;
import cz.kpsys.db.model.v2.DefFond;
import cz.kpsys.db.model.v2.DefRez;
import cz.kpsys.db.model.v2.ExterniZdroje;
import cz.kpsys.db.model.v2.FDef;
import cz.kpsys.db.model.v2.Kat1_2;
import cz.kpsys.db.model.v2.Kat1_2Opakovani;
import cz.kpsys.db.model.v2.Kat1_4;
import cz.kpsys.db.model.v2.Kat1_5;
import cz.kpsys.db.model.v2.Kat1_7;
import cz.kpsys.db.model.v2.Kataut_4;
import cz.kpsys.kpwin2.rest.Configuration;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.marc.Field008;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.RecordRef;
import cz.kpsys.marc.SubField;
import cz.kpsys.service.LuceneCustomFieldTypes;
import cz.kpsys.service.LuceneManager;
import cz.kpsys.service.LuceneManagerNG;
import cz.kpsys.service.Utils;
import cz.kpsys.service.cache.RecordIdCache;
import cz.kpsys.service.model.DocumentsPair;
import cz.kpsys.service.rezy.GeneratorRezuData;
import cz.kpsys.service.rezy.RezyFactory;
import cz.kpsys.service.rezy.TGeneratorRezu;
import cz.kpsys.service.rezy.TGeneratorRezu$;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.text.TextStringBuilder;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.InfoStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class LuceneManager {
    public static final String REZS_ROK = "REZS_ROK";
    public static final String REZS_JAZYK = "REZS_JAZYK";
    public static final String REZS_FOND = "REZS_FOND";
    public static final String PNAZEV = "PNAZEV";
    public static final String PPRIRCISLO = "PPRIRCISLO";
    public static final String PSIGNATURA = "PSIGNATURA";
    public static final String PUZIVATEL = "PUZIVATEL";
    public static final String PBARCOD = "PBARCOD";
    public static final String REZS_VYPKAT = "REZS_VYPKAT";
    public static final String REZS_LOKACE = "REZS_LOKACE";
    public static final String REZS_PUJC = "REZS_PUJC";
    public static final String REZS_ZDROJDOK = "REZS_ZDROJDOK";
    public static final String REZS_UNINAZEV = "REZS_UNINAZEV";
    public static final String REZS_DESKRIPTOR = "REZS_DESKRIPTOR";
    public static final String REZS_PREDMET = "REZS_PREDMET";
    public static final String REZS_AUTOR = "REZS_AUTOR";
    public static final String REZS_DB = "REZS_DB";
    public static final String REZS_EXTERNI = "REZS_EXTERNI";
    public static final String REZS_DOSTUPNOST = "REZS_DOSTUPNOST";
    public static final String REZS_PUJC_VOLNA_ABS = "REZS_PUJC_VOLNA_ABS";
    public static final String REZS_PUJC_VOLNA_PREZ = "REZS_PUJC_VOLNA_PREZ";
    public static final String REZS_TYP_FULLTEXT = "REZS_TYP_FULLTEXT";
    public static final String REZS_DAT_VYT = "REZS_DAT_VYT";
    public static final String REZS_DAT_MOD = "REZS_DAT_MOD";
    public static final String REZS_ROK_STT = "REZS_ROK_STT";
    public static final String REZS_CIRK = "REZS_CIRK";
    public static final String REZS_PUBLIC_DEP = "REZS_PUBLIC_DEP";
    public static final String REZS_TEMSKUP = "REZS_TEMSKUP";
    public static final String REZS_POMOCNE = "REZS_POMOCNE";
    public static final String NULL = "NULL";
    static final Logger logger = LoggerFactory.getLogger(LuceneManager.class);
    private static final Analyzer whiteSpaceAnalyzerDia = new WhitespaceAnalyzer();
    private static final Analyzer whiteSpaceAnalyzerNoDia = new WhitespaceAnalyzer();
    public static IndexWriter indexWriterDia;
    public static IndexWriter indexWriterNoDia;
    public static volatile boolean running;
    public static volatile Date lastCommitTime;
    public static Directory fsDirectoryDia;
    public static Directory fsDirectoryNoDia;
    private static String luceneIndexDir;
    private static DbCore2 core2;
    static IndexDeletionPolicy deletionPolicyDia;
    static IndexDeletionPolicy deletionPolicyNoDia;
    static final ThreadPoolExecutor luceneWriteExecutor;
    public static volatile boolean needToCommit;
    static final boolean LADENI_MAZANI_ZAZNAMU = false;

    private static void initCache(DbConfig dbConfig) throws SQLException {
        Connection coreConn = ProxoolUtil.obtainConnection();
        core2 = new DbCore2(coreConn);
        core2.setConnection(coreConn);
    }

    public static DocumentsPair oindexujZaznamDok(DbCore2 core2, Record r, List<LuceneField> kliceLucene) throws SQLException {
        DocumentsPair pair = new DocumentsPair();
        if (r.getStatus4() == 9 || r.getStatus4() == 99 || kliceLucene == null) {
            LuceneManager.vymazKlice((String)r.recordId);
            return null;
        }
        LuceneManager.zapisKliceDiaNoDia((DocumentsPair)pair, (Record)r, kliceLucene);
        LuceneManager.zapisStatusEditorEditaceOthers((DocumentsPair)pair, (Record)r);
        if (!r.isAuthority()) {
            RecordReconstructor2 rc2 = new RecordReconstructor2(core2);
            QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
            List exemplare = (List)qr.query("SELECT * FROM KAT1_5 WHERE RECORD_ID=?", (ResultSetHandler)BeanHandlers.kat1_5BLH(), new Object[]{r.recordId});
            List rezy = DbCache2.rezy;
            try {
                Kat1_4 kat1_4 = (Kat1_4)qr.query("SELECT * FROM KAT1_4 WHERE ID_ZAZ=?", (ResultSetHandler)BeanHandlers.kat1_4BH(), new Object[]{r.getId()});
                LuceneManager.zapisRezy((DocumentsPair)pair, (Record)r, (Kat1_4)kat1_4, null, (List)rezy, (QueryRunner)qr, (List)exemplare);
            }
            catch (EvalError e) {
                logger.error("problem pri generovani rezu", (Throwable)e);
            }
            LuceneManager.zapisVazbyAutority((DocumentsPair)pair, (Record)r, (DbCore2)core2);
        }
        return pair;
    }

    public static DocumentsPair oindexujZaznamAut(DbCore2 core2, Record r, List<LuceneField> kliceLucene) throws SQLException {
        DocumentsPair pair = new DocumentsPair();
        if (r.getStatus4() == 9 || r.getStatus4() == 99 || kliceLucene == null) {
            LuceneManager.vymazKlice((String)r.recordId);
            return null;
        }
        LuceneManager.zapisKliceDiaNoDia((DocumentsPair)pair, (Record)r, kliceLucene);
        LuceneManager.zapisStatusEditorEditaceOthers((DocumentsPair)pair, (Record)r);
        if (r.isAuthority()) {
            RecordReconstructor2 rc2 = new RecordReconstructor2(core2);
            QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
            List rezy = DbCache2.rezy;
            try {
                Kataut_4 kataut_4 = (Kataut_4)qr.query("SELECT * FROM KATAUT_4 WHERE ID_AUT=?", (ResultSetHandler)BeanHandlers.kataut_4BH(), new Object[]{r.getId()});
                LuceneManager.zapisRezy((DocumentsPair)pair, (Record)r, null, (Kataut_4)kataut_4, (List)rezy, (QueryRunner)qr, (List)Collections.EMPTY_LIST);
            }
            catch (EvalError e) {
                logger.error("problem pri generovani rezu", (Throwable)e);
            }
            LuceneManager.zapisVazbyAutority((DocumentsPair)pair, (Record)r, (DbCore2)core2);
        }
        return pair;
    }

    private static String primaryKey(long idZaz, boolean isAuth) {
        String pkValue = (isAuth ? "A" : "D") + idZaz;
        return pkValue;
    }

    public static boolean commitnutoViceNezPredMinutou() {
        return Utils.now().getTime() - lastCommitTime.getTime() > TimeUnit.MINUTES.toMillis(1L);
    }

    public static void writeAndCommit(Record r, DocumentsPair pair, boolean forceCommit) {
        Runnable task = () -> {
            try {
                if (pair != null) {
                    String pkValue = LuceneManager.primaryKey((long)r.getId(), (boolean)r.isAuthority());
                    TextField primaryKey = new TextField("PK", pkValue, Field.Store.YES);
                    pair.docDia.add((IndexableField)primaryKey);
                    pair.docNoDia.add((IndexableField)primaryKey);
                    String recordId = r.recordId;
                    if (recordId != null) {
                        StringField fieldRecordId = new StringField("RECORD_ID", recordId, Field.Store.YES);
                        pair.docDia.add((IndexableField)fieldRecordId);
                        pair.docNoDia.add((IndexableField)fieldRecordId);
                        Term primaryKeyTerm = new Term("RECORD_ID", recordId);
                        indexWriterDia.updateDocument(primaryKeyTerm, (Iterable)pair.docDia);
                        indexWriterNoDia.updateDocument(primaryKeyTerm, (Iterable)pair.docNoDia);
                    } else {
                        logger.warn("u zaznamu " + r.getFondId() + " chybi RECORD_ID");
                        Term primaryKeyTerm = new Term("PK", pkValue);
                        indexWriterDia.updateDocument(primaryKeyTerm, (Iterable)pair.docDia);
                        indexWriterNoDia.updateDocument(primaryKeyTerm, (Iterable)pair.docNoDia);
                    }
                }
                if (forceCommit || LuceneManager.commitnutoViceNezPredMinutou()) {
                    LuceneManager.forceCommitWriter();
                } else {
                    needToCommit = true;
                }
            }
            catch (Exception e) {
                logger.error("Error pri commit do Lucene", (Throwable)e);
            }
        };
        luceneWriteExecutor.submit(task);
    }

    public static synchronized void forceCommitWriter() {
        try {
            logger.debug("lucene commit");
            lastCommitTime = Utils.now();
            indexWriterDia.commit();
            indexWriterNoDia.commit();
            logger.debug("lucene commit done");
        }
        catch (Exception e) {
            logger.error("problem pri commit Lucene", (Throwable)e);
        }
    }

    public static void optimize() throws IOException {
        logger.info("spustena optimalizace Lucene indexu");
        indexWriterDia.forceMergeDeletes();
        indexWriterDia.commit();
        indexWriterNoDia.forceMergeDeletes();
        indexWriterNoDia.commit();
        indexWriterDia.forceMerge(1);
        indexWriterDia.commit();
        indexWriterNoDia.forceMerge(1);
        indexWriterNoDia.commit();
        logger.info("optimalizace Lucene indexu dobehla");
    }

    private static void zapisVazbyAutority(DocumentsPair pair, Record r, DbCore2 core2) throws SQLException {
        QueryRunnerOpened qr = core2.obtainQueryRunnerOpened();
        Collection listKat1_7 = LuceneManager.zjistiVazbyNaAutority((Record)r);
        for (Kat1_7 kat1_7 : listKat1_7) {
            LongPoint f = new LongPoint("REL_AUT", new long[]{kat1_7.FK_AUT});
            pair.docDia.add((IndexableField)f);
            pair.docNoDia.add((IndexableField)f);
        }
    }

    private static Collection<Kat1_7> zjistiVazbyNaAutority(Record r) {
        HashSet<Kat1_7> setKat1_7 = new HashSet<Kat1_7>();
        boolean marc21Strict = KPWINServiceApplication.configuration.marc21strict;
        for (cz.kpsys.marc.Field f : r.getFields()) {
            if (marc21Strict && f.getNumber() < 10) continue;
            for (SubField sf : f.getSubfields()) {
                if (sf.getAuthLink() == 0L) continue;
                Kat1_7 kat1_7 = new Kat1_7();
                kat1_7.CIS_FOND = (short)sf.getAuthLinkFond();
                kat1_7.CIS_POL = f.getNumber();
                kat1_7.FK_AUT = sf.getAuthLinkID();
                kat1_7.FK_ZAZ = r.getId();
                kat1_7.TARGET_RECORD_ID = RecordIdCache.getByCisZazAut((long)kat1_7.FK_AUT, (boolean)true).recordId();
                kat1_7.SOURCE_RECORD_ID = r.recordId;
                setKat1_7.add(kat1_7);
            }
        }
        return setKat1_7;
    }

    public static void zapisTOC(DocumentsPair pair, String toc) {
        if (toc != null) {
            LuceneManager.zapisRezExtraBezDia((DocumentsPair)pair, (String)"PTOC", (String)toc.toLowerCase(), (boolean)false, (boolean)true);
        }
    }

    private static void zapisRezy(DocumentsPair pair, Record r, Kat1_4 kat1_4, Kataut_4 kataut_4, List<DefRez> rezy, QueryRunner qr, List<Kat1_5> exemplare) throws SQLException, EvalError {
        for (DefRez rez : rezy) {
            if (rez.getMNOZINA() < 2 && (!r.isAuthority() && rez.getMNOZINA() == 1 || r.isAuthority() && rez.getMNOZINA() == 0) || !rez.isINDEXOVAT()) continue;
            Option generatorRezuFactory = RezyFactory.rez((int)rez.getID_REZ());
            if (generatorRezuFactory.isDefined()) {
                TGeneratorRezu degenerator = (TGeneratorRezu)generatorRezuFactory.get();
                GeneratorRezuData data = new GeneratorRezuData(r, kat1_4, kataut_4, rez, exemplare);
                Connection conn = ProxoolUtil.obtainConnection();
                try {
                    DbCore2 core2Rezy = new DbCore2(conn);
                    ScalaRunnerOpened sro = core2Rezy.obtainScalaRunnerOpened();
                    try {
                        Set rezyData = degenerator.generujRez(sro, data);
                        Tuple2 lucenePole = degenerator.generujLuceneFields(rezyData);
                        for (Field f : ((Set)lucenePole._1()).seq()) {
                            pair.docDia.add((IndexableField)f);
                        }
                        for (Field f : ((Set)lucenePole._2()).seq()) {
                            pair.docNoDia.add((IndexableField)f);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("doslo k problemu pri generovani rezu " + degenerator + " v zaznamu " + data.r().getFondId(), (Throwable)e);
                    }
                    core2Rezy.closeConnectionCommit();
                    continue;
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                    continue;
                }
            }
            logger.warn("pozadovany rez neni definovan " + rez + " a bude proto ignorovan");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupLucene(boolean dia, String toDir) {
        SnapshotDeletionPolicy policy;
        if (dia) {
            policy = (SnapshotDeletionPolicy)deletionPolicyDia;
            indexWriter = indexWriterDia;
        } else {
            policy = (SnapshotDeletionPolicy)deletionPolicyNoDia;
            indexWriter = indexWriterNoDia;
        }
        try {
            IndexCommit indexCommit = policy.snapshot();
            try {
                for (String fileName : indexCommit.getFileNames()) {
                    if (fileName.equals("write.lock")) continue;
                    FileUtils.copyFile((File)new File(fileName), (File)new File(toDir));
                }
            }
            finally {
                policy.release(indexCommit);
            }
        }
        catch (IOException e) {
            logger.error("nepodarilo se zalozit snapshot lucene indexu", (Throwable)e);
        }
    }

    private static void zapisNullPujcovnuDoRezu(DocumentsPair pair, boolean usingDataType) {
        if (!usingDataType) {
            String budovaKey = "NULL";
            LuceneManager.zapisRez((DocumentsPair)pair, (String)"REZS_PUJC", (String)"NULL");
        } else {
            LuceneManager.zapisRez((DocumentsPair)pair, (String)"REZS_PUJC", (String)"NULL");
        }
    }

    private static void zapisRezDeskriptor(DocumentsPair pair, Record r) {
        if (!KPWINServiceApplication.getConfiguration().marc21strict) {
            return;
        }
        HashSet jazyky = new HashSet();
        List pole655 = r.getFields(655);
        for (cz.kpsys.marc.Field pole : pole655) {
            SubField podpoleA = pole.getFirstSubfield("a");
            if (podpoleA == null) continue;
            String content = podpoleA.getContent();
            boolean slovnikRelated = LuceneManager.navazanoNaValidacniSlovnik((int)655, (String)"a");
            if (!StringUtils.isNotBlank((CharSequence)content)) continue;
            if (slovnikRelated) {
                LuceneManager.zapisRez((DocumentsPair)pair, (String)"REZS_DESKRIPTOR", (String)("DEF_VAL.POPIS.58." + content.replace(" ", "_")));
                continue;
            }
            LuceneManager.zapisRez((DocumentsPair)pair, (String)"REZS_DESKRIPTOR", (String)content);
        }
    }

    protected static boolean navazanoNaValidacniSlovnik(int cisloPole, String prefixPodpole) {
        FDef fdef = DbCache2.najdiFDef((int)cisloPole, (String)prefixPodpole);
        if (fdef != null) {
            return !StringUtils.isBlank((CharSequence)fdef.PIC);
        }
        return false;
    }

    private static boolean jeStatusExemplareIndexovatelny(short fk_STATUS) {
        return fk_STATUS != 10 && fk_STATUS != 11;
    }

    private static void zapisRezFond(DocumentsPair pair, Record r) {
        if (r.isAuthority()) {
            DefFond fond = (DefFond)DbCache2.defAutFondMap.get(r.getFond());
            String fondKey = "DEF_AUTFOND.NAZEV." + fond.getID_FOND();
            LuceneManager.zapisRez((DocumentsPair)pair, (String)"REZS_FOND", (String)fondKey);
        } else {
            DefFond fond = (DefFond)DbCache2.defDokFondMap.get(r.getFond());
            String fondKey = "DEF_DOKFOND.NAZEV." + fond.getID_FOND();
            LuceneManager.zapisRez((DocumentsPair)pair, (String)"REZS_FOND", (String)fondKey);
        }
    }

    private static void zapisRezJazyk(DocumentsPair pair, Record r) throws SQLException {
        if (!KPWINServiceApplication.getConfiguration().marc21strict) {
            return;
        }
        HashSet<String> jazyky = new HashSet<String>();
        List pole41 = r.getFields(41);
        for (cz.kpsys.marc.Field pole : pole41) {
            SubField podpoleA = pole.getFirstSubfield("a");
            if (podpoleA == null) continue;
            jazyky.add(podpoleA.getContent());
        }
        cz.kpsys.marc.Field pole008 = r.getFirstField(8);
        if (pole008 != null) {
            String kodJazyka = Field008.instance((cz.kpsys.marc.Field)pole008).getKodJazyka();
            jazyky.add(kodJazyka);
        }
        List slovnik = DbCache2.validacniSlovnik((String)"VAL63K");
        for (String jazyk : jazyky) {
            if (jazyk != null) {
                jazyk = jazyk.replace("|", "");
            }
            LuceneManager.zapisRez((DocumentsPair)pair, (String)"REZS_JAZYK", (String)("DEF_VAL.POPIS.63K." + jazyk));
        }
    }

    private static void zapisRezDb(DocumentsPair pair, Record r) throws SQLException {
        if (!KPWINServiceApplication.configuration.masterMode) {
            return;
        }
        HashSet<Short> databaze = new HashSet<Short>();
        DbCore2 core2 = new DbCore2();
        try {
            core2.setConnection(ProxoolUtil.obtainConnection());
            QueryRunner qr = core2.obtainQueryRunner();
            List centralPropojs = (List)qr.query("SELECT * FROM CENTRAL_PROPOJ WHERE FK_ZAZ_CENTRAL=? AND JE_AUTORITA=?", (ResultSetHandler)new KPSYSBeanListHandler(CentralPropoj.class), new Object[]{r.getId()});
            for (CentralPropoj propoj : centralPropojs) {
                databaze.add(propoj.getFK_DATABAZE());
            }
            for (Short db : databaze) {
                LuceneManager.zapisRez((DocumentsPair)pair, (String)"REZS_DB", (String)("CENTRAL_DATABAZE.NAZEV_DB." + db));
            }
            core2.closeConnectionCommit();
        }
        catch (SQLException se) {
            core2.closeConnectionRollback();
        }
    }

    private static void zapisRezExterni(DocumentsPair pair, Record r) throws SQLException {
        if (ProxoolUtil.engine() != DatabaseEngine.FIREBIRD) {
            throw new UnsupportedOperationException("Db engine " + ProxoolUtil.engine() + " is not supported");
        }
        HashSet<CallSite> zdroje = new HashSet<CallSite>();
        DbCore2 core2 = new DbCore2();
        try {
            core2.setConnection(ProxoolUtil.obtainConnection());
            QueryRunner qr = core2.obtainQueryRunner();
            List externiZdroje = (List)qr.query("SELECT * FROM EXTERNI_ZDROJE WHERE FK_ZAZ=?", (ResultSetHandler)new KPSYSBeanListHandler(ExterniZdroje.class), new Object[]{r.getId()});
            for (ExterniZdroje externiZdroje2 : externiZdroje) {
                String zdrojId = externiZdroje2.getZDROJ();
                if (!StringUtils.isNotBlank((CharSequence)zdrojId)) continue;
                zdroje.add((CallSite)((Object)("DEF_EXTERNI_TYP.ID_EXTERNI_TYP." + zdrojId.toLowerCase())));
            }
            for (String string : zdroje) {
                LuceneManager.zapisRez((DocumentsPair)pair, (String)"REZS_EXTERNI", (String)string);
            }
            core2.closeConnectionCommit();
        }
        catch (SQLException se) {
            core2.closeConnectionRollback();
        }
    }

    private static void zapisDatumModifikace(QueryRunner qr, DocumentsPair pair, Record r) throws SQLException {
        Timestamp datMod;
        if (r.isAuthority()) {
            Kat1_4 kat1_4 = (Kat1_4)qr.query("SELECT * FROM KAT1_4 WHERE ID_ZAZ=?", (ResultSetHandler)BeanHandlers.kat1_4BH(), new Object[]{r.getId()});
            datMod = kat1_4.getDATCAS();
        } else {
            Kataut_4 kataut_4 = (Kataut_4)qr.query("SELECT * FROM KATAUT_4 WHERE ID_AUT=?", (ResultSetHandler)BeanHandlers.kataut_4BH(), new Object[]{r.getId()});
            datMod = kataut_4.getDATCAS();
        }
        if (datMod != null) {
            String value = TGeneratorRezu$.MODULE$.sdfRezyDat().format(datMod);
            LuceneManager.zapisRez((DocumentsPair)pair, (String)"REZS_DAT_MOD", (String)value);
        }
    }

    private static void zapisRezExtraBezDia(DocumentsPair pair, String nazevRezu, String obsah, boolean store, boolean analyzed) {
        if (obsah == null) {
            return;
        }
        String obsahBezDia = LuceneManager.odstranDiakritiku((String)obsah);
        if (analyzed) {
            TextField obsahDiaField = new TextField(nazevRezu, obsah, store ? Field.Store.YES : Field.Store.NO);
            pair.docDia.add((IndexableField)obsahDiaField);
            TextField obsahBezDiaField = new TextField(nazevRezu, obsahBezDia, store ? Field.Store.YES : Field.Store.NO);
            pair.docNoDia.add((IndexableField)obsahBezDiaField);
        } else {
            StringField obsahDiaField = new StringField(nazevRezu, obsah, store ? Field.Store.YES : Field.Store.NO);
            pair.docDia.add((IndexableField)obsahDiaField);
            StringField obsahBezDiaField = new StringField(nazevRezu, obsahBezDia, store ? Field.Store.YES : Field.Store.NO);
            pair.docNoDia.add((IndexableField)obsahBezDiaField);
        }
    }

    public static String odstranDiakritiku(String obsah) {
        return Normalizer.normalize(obsah, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").toLowerCase(Locale.ENGLISH);
    }

    private static void zapisRez(DocumentsPair pair, String nazevRezu, String obsah) {
        if (StringUtils.isBlank((CharSequence)obsah)) {
            return;
        }
        StringField fond = new StringField(nazevRezu, obsah, Field.Store.YES);
        pair.docDia.add((IndexableField)fond);
        pair.docNoDia.add((IndexableField)fond);
    }

    private static void zapisPole(DocumentsPair pair, String nazevPole, String obsah) {
        if (StringUtils.isBlank((CharSequence)obsah)) {
            return;
        }
        TextField poleDia = new TextField(nazevPole, obsah, Field.Store.NO);
        TextField poleNoDia = new TextField(nazevPole, LuceneManager.odstranDiakritiku((String)obsah), Field.Store.NO);
        pair.docDia.add((IndexableField)poleDia);
        pair.docNoDia.add((IndexableField)poleNoDia);
    }

    private static void zapisPoleNedelMezery(DocumentsPair pair, String nazevPole, String obsah) {
        if (StringUtils.isBlank((CharSequence)obsah)) {
            return;
        }
        StringField poleDia = new StringField(nazevPole, obsah, Field.Store.NO);
        StringField poleNoDia = new StringField(nazevPole, LuceneManager.odstranDiakritiku((String)obsah), Field.Store.NO);
        pair.docDia.add((IndexableField)poleDia);
        pair.docNoDia.add((IndexableField)poleNoDia);
    }

    private static void zapisStatusEditorEditaceOthers(DocumentsPair pair, Record r) {
        IntPoint status = new IntPoint("STATUS", new int[]{r.getStatus4()});
        pair.docDia.add((IndexableField)status);
        pair.docNoDia.add((IndexableField)status);
        StoredField statusStored = new StoredField("STATUS", r.getStatus4());
        pair.docDia.add((IndexableField)statusStored);
        pair.docNoDia.add((IndexableField)statusStored);
        StringField editor = new StringField("EDITOR", Integer.toString(r.getFkUziv()), Field.Store.NO);
        pair.docDia.add((IndexableField)editor);
        pair.docNoDia.add((IndexableField)editor);
        String dts = DateTools.dateToString((Date)Utils.now(), (DateTools.Resolution)DateTools.Resolution.HOUR);
        StringField dateIndexed = new StringField("DATUM_INDEXACE", dts, Field.Store.YES);
        pair.docDia.add((IndexableField)dateIndexed);
        pair.docNoDia.add((IndexableField)dateIndexed);
        LuceneManagerNG.indexOthers((DocumentsPair)pair, (Record)r);
    }

    public static ZalozeniPrepravka kontrolaZalozeniIndexu(String luceneIndexDir, String indexRelDir) throws IOException, AppServerStatus {
        File indexFileDir;
        ZalozeniPrepravka prepravka = new ZalozeniPrepravka();
        prepravka.indexFileDir = indexFileDir = new File(luceneIndexDir + File.separator + indexRelDir);
        File segmentsGenFile = new File(luceneIndexDir + File.separator + indexRelDir + File.separator + "segments.gen");
        if (!indexFileDir.exists() || LuceneManager.jePrazdny((File)indexFileDir)) {
            logger.warn("adresar s indexem neexistuje, zakladam " + indexFileDir.getAbsolutePath());
            indexFileDir.mkdirs();
            prepravka.create = true;
        }
        if (!segmentsGenFile.exists()) {
            prepravka.create = true;
        }
        LuceneManager.kontrolaZamku((File)indexFileDir);
        prepravka.directory = FSDirectory.open((Path)indexFileDir.toPath());
        return prepravka;
    }

    public static void initLucene(String luceneIndexDir, DbConfig dbConfig) throws IOException, SQLException, AppServerStatus {
        LuceneManager.luceneIndexDir = luceneIndexDir;
        if (luceneIndexDir == null) {
            return;
        }
        ZalozeniPrepravka diaPrepravka = LuceneManager.kontrolaZalozeniIndexu((String)luceneIndexDir, (String)"dia");
        ZalozeniPrepravka noDiaPrepravka = LuceneManager.kontrolaZalozeniIndexu((String)luceneIndexDir, (String)"nodia");
        fsDirectoryDia = diaPrepravka.directory;
        fsDirectoryNoDia = noDiaPrepravka.directory;
        deletionPolicyDia = new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy());
        deletionPolicyNoDia = new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy());
        try {
            logger.info("otviram indexy");
            LuceneManager.openWriters();
        }
        catch (IndexFormatTooOldException e) {
            logger.error("nalezen lucene index ve starem (nepodporovanem) formatu, mazu a zakladam prazdny index", (Throwable)e);
            try {
                FileUtils.cleanDirectory((File)new File(luceneIndexDir + File.separator + "dia"));
                FileUtils.cleanDirectory((File)new File(luceneIndexDir + File.separator + "nodia"));
            }
            catch (Exception ex) {
                logger.error("nepodarilo se vycistit stare Lucene indexy, je nutno smazat rucne a spustit AS znovu", (Throwable)ex);
                System.exit(33);
            }
            LuceneManager.initLucene((String)luceneIndexDir, (DbConfig)dbConfig);
        }
    }

    private static void optimizeWriterConfig(IndexWriterConfig iwc) {
        iwc.setRAMBufferSizeMB(1.34217728E8);
        iwc.setMaxBufferedDeleteTerms(1024);
    }

    private static void openWriters() throws IOException {
        boolean readOnly = Configuration.luceneReadonly;
        boolean debug = Configuration.luceneDebug;
        if (readOnly) {
            if (Configuration.indexingServiceEnabled) {
                logger.error("lucene v rezimu READONLY a zaroven zapnuta indexace, neplatna konfigurace");
                System.exit(991);
            }
            logger.warn("lucene v rezimu READONLY");
        } else {
            IndexWriterConfig iwcDia = new IndexWriterConfig(whiteSpaceAnalyzerDia);
            iwcDia.setIndexDeletionPolicy(deletionPolicyDia);
            LuceneManager.optimizeWriterConfig((IndexWriterConfig)iwcDia);
            indexWriterDia = new IndexWriter(fsDirectoryDia, iwcDia);
            IndexWriterConfig iwcNoDia = new IndexWriterConfig(whiteSpaceAnalyzerNoDia);
            iwcNoDia.setIndexDeletionPolicy(deletionPolicyNoDia);
            if (debug) {
                logger.info("zapinam debug vypis pro nodia index");
                iwcNoDia.setInfoStream((InfoStream)new /* Unavailable Anonymous Inner Class!! */);
            }
            LuceneManager.optimizeWriterConfig((IndexWriterConfig)iwcNoDia);
            indexWriterNoDia = new IndexWriter(fsDirectoryNoDia, iwcNoDia);
        }
    }

    private static boolean jePrazdny(File dir) {
        return dir.list().length == 0;
    }

    private static void kontrolaZamku(File indexDir) throws AppServerStatus {
        int LOCK_DELETION_FAIL = 668;
        File lockFile = new File(indexDir.getAbsoluteFile() + File.separator + "write.lock");
        if (lockFile.exists()) {
            logger.error("nalezen zamek Lucene indexu " + lockFile.getAbsolutePath());
            try {
                boolean zamekSmazan = lockFile.delete();
                if (!zamekSmazan) {
                    String message = "zamek lucene indexu se nepodarilo smazat " + lockFile.getAbsolutePath();
                    logger.error(message);
                    throw new AppServerStatus(message, 668);
                }
                logger.warn("zamek byl smazan");
            }
            catch (Exception e) {
                logger.error("selhalo mazani zamku lucene, nelze pokracovat", (Throwable)e);
                System.exit(668);
            }
        }
    }

    public static String getLuceneIndexDir(boolean diacritic) {
        if (diacritic) {
            return luceneIndexDir + File.separator + "dia";
        }
        return luceneIndexDir + File.separator + "nodia";
    }

    public static List<Kat1_2Opakovani> klicePodlePoli(List<Kat1_2> originalniKlice) {
        ArrayList<Kat1_2Opakovani> ret = new ArrayList<Kat1_2Opakovani>(originalniKlice.size());
        StrBuilder sbFlat = new StrBuilder(1024);
        StrBuilder sbUTF = new StrBuilder(1024);
        int cisloPoslednihoOpakovani = 0;
        int cisloPoslednihoPole = 0;
        String lastSuffix = null;
        Kat1_2Opakovani kat1_2o = null;
        if (originalniKlice.size() > 0) {
            for (Kat1_2 kat1_2 : originalniKlice) {
                kat1_2o = (Kat1_2Opakovani)kat1_2;
                if ((cisloPoslednihoPole != kat1_2o.CIS_POL || cisloPoslednihoOpakovani != kat1_2o.getCisloOpakovani() || lastSuffix != kat1_2o.getSuffix()) && cisloPoslednihoPole != 0) {
                    if (cisloPoslednihoOpakovani > 1) {
                        // empty if block
                    }
                    LuceneManager.zapisNastradanyObsahPole(ret, (StrBuilder)sbFlat, (StrBuilder)sbUTF, (int)cisloPoslednihoPole, (Kat1_2Opakovani)kat1_2o);
                }
                cisloPoslednihoPole = kat1_2.getCIS_POL();
                cisloPoslednihoOpakovani = kat1_2o.getCisloOpakovani();
                lastSuffix = kat1_2o.getSuffix();
                sbFlat.append(kat1_2.FLAT_KLIC).append(" ");
                sbUTF.append(kat1_2.UTF_KLIC).append(" ");
            }
            LuceneManager.zapisNastradanyObsahPole(ret, (StrBuilder)sbFlat, (StrBuilder)sbUTF, (int)cisloPoslednihoPole, kat1_2o);
        }
        return ret;
    }

    private static void zapisNastradanyObsahPole(List<Kat1_2Opakovani> ret, StrBuilder sbFlat, StrBuilder sbUTF, int cisloPoslednihoPole, Kat1_2Opakovani kat1_2o) {
        Kat1_2Opakovani kat1_2new = new Kat1_2Opakovani();
        kat1_2new.CIS_POL = cisloPoslednihoPole;
        kat1_2new.FK_DOKFOND = kat1_2o.getFK_DOKFOND();
        kat1_2new.FLAT_KLIC = sbFlat.toString().trim();
        kat1_2new.UTF_KLIC = sbUTF.toString().trim();
        kat1_2new.setSuffix(kat1_2o.getSuffix());
        sbFlat.clear();
        sbUTF.clear();
        ret.add(kat1_2new);
    }

    public static void zapisKliceDiaNoDia(DocumentsPair pair, Record r, List<LuceneField> kliceLucene) {
        if (luceneIndexDir == null) {
            return;
        }
        TextStringBuilder stDia = new TextStringBuilder(4096);
        TextStringBuilder stNoDia = new TextStringBuilder(4096);
        for (LuceneField lf : kliceLucene) {
            Field klicDia = new Field("P" + lf.key, lf.utfContent, LuceneCustomFieldTypes.poleFieldType());
            pair.docDia.add((IndexableField)klicDia);
            Field klicNoDia = new Field("P" + lf.key, lf.flatContent, LuceneCustomFieldTypes.poleFieldType());
            pair.docNoDia.add((IndexableField)klicNoDia);
            stDia.append(lf.utfContent).append(" ");
            stNoDia.append(lf.flatContent).append(" ");
        }
        if (!r.isAuthority()) {
            LuceneManager.zapisTOC((DocumentsPair)pair, (String)r.getToc());
        }
        Field klicAllDia = new Field("PALL", stDia.toString().toLowerCase(), LuceneCustomFieldTypes.poleFieldType());
        pair.docDia.add((IndexableField)klicAllDia);
        Field klicAllNoDia = new Field("PALL", stNoDia.toString().toLowerCase(), LuceneCustomFieldTypes.poleFieldType());
        pair.docNoDia.add((IndexableField)klicAllNoDia);
    }

    public static TermQuery termIDQuery(long idZaz) {
        TermQuery termIDQuery = new TermQuery(LuceneManager.termID((long)idZaz));
        return termIDQuery;
    }

    public static Term termID(long idZaz) {
        return new Term("ID", Long.toString(idZaz));
    }

    public static Query deleteQuery(long idZaz, boolean isAuthority) {
        TermQuery termIDQuery = LuceneManager.termIDQuery((long)idZaz);
        Query termFondQuery = isAuthority ? DbCache.luceneQueryToDeleteAuts() : DbCache.luceneQueryToDeleteDocs();
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)termIDQuery, BooleanClause.Occur.MUST).add(termFondQuery, BooleanClause.Occur.MUST).build();
        return booleanQuery;
    }

    public static void vymazKlice(String recordId) {
        if (luceneIndexDir == null) {
            logger.warn("neni inicializovan Lucene index");
            return;
        }
        RecordRef recordRef = RecordIdCache.getByRecordId((String)recordId);
        logger.info("mazu klice z lucene k zaznamu " + recordRef);
        if (recordRef.cisZaz() == 0L) {
            logger.error("pozadavek na smazani klicu k zaznamu 0");
            return;
        }
        try {
            indexWriterDia.deleteDocuments(new Term[]{new Term("RECORD_ID", recordId)});
            indexWriterNoDia.deleteDocuments(new Term[]{new Term("RECORD_ID", recordId)});
            long idZaz = recordRef.cisZaz();
            boolean isAuthority = recordRef.auth();
            boolean MAZAT_POSTARU = true;
            String pk = LuceneManager.primaryKey((long)idZaz, (boolean)isAuthority);
            indexWriterDia.deleteDocuments(new Term[]{new Term("PK", pk)});
            indexWriterNoDia.deleteDocuments(new Term[]{new Term("PK", pk)});
            boolean MAZAT_TOTALNE_POSTARU = true;
            Query deleteQuery = LuceneManager.deleteQuery((long)idZaz, (boolean)isAuthority);
            indexWriterDia.deleteDocuments(new Query[]{deleteQuery});
            indexWriterNoDia.deleteDocuments(new Query[]{deleteQuery});
        }
        catch (Exception e) {
            logger.warn("problem pri mazani klicu k zaznamu " + recordRef, (Throwable)e);
        }
    }

    public static void stopIndexing() {
        running = false;
    }

    public static void pridejFullText(DocumentsPair pair, String fullText) {
        if (fullText == null) {
            return;
        }
        String data = fullText.toLowerCase();
        TextField klicFullDia = new TextField("PFULLTEXT", data, Field.Store.NO);
        pair.docDia.add((IndexableField)klicFullDia);
        TextField klicFullNoDia = new TextField("PFULLTEXT", LuceneManager.odstranDiakritiku((String)data), Field.Store.NO);
        pair.docNoDia.add((IndexableField)klicFullNoDia);
    }

    public static boolean luceneInicializovan() {
        return indexWriterDia != null && indexWriterNoDia != null;
    }

    static {
        running = false;
        lastCommitTime = Utils.now();
        luceneWriteExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        needToCommit = false;
    }
}

