/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.service;

import cz.kpsys.service.SUtils;
import cz.kpsys.service.UUIDCache;
import cz.kpsys.service.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDCache {
    private static final UUIDCache instance = new UUIDCache();
    private static final Logger logger = LoggerFactory.getLogger(UUIDCache.class);
    private static final String SECRET = Utils.decodeString((String)"b2ZaNFlyN1czN042VWxhaUVDbU5TalBlMzU1MmdMdDk=");
    final Map<String, UUIDItem> cache = Collections.synchronizedMap(new HashMap());
    long lastCheck;

    public static String generateKey(String uuid) {
        String combinedString = uuid + SECRET;
        return SUtils.md5Hash((String)combinedString);
    }

    private UUIDCache() {
    }

    public static UUIDCache getInstance() {
        return instance;
    }

    public String generateUUID() {
        if (this.nutnoKontrolovatProsle()) {
            this.kontrolujProsle();
        }
        UUIDItem item = new UUIDItem(this);
        String key = item.key;
        this.cache.put(key, item);
        return item.uuid;
    }

    boolean nutnoKontrolovatProsle() {
        long now = Utils.now().getTime();
        long intervalKontroly = 60000L;
        return now - this.lastCheck > 60000L;
    }

    public boolean isKeyValid(String key) {
        UUIDItem item = (UUIDItem)this.cache.get(key);
        if (item == null) {
            return false;
        }
        return this.isUUIDValid(item);
    }

    boolean isUUIDValid(UUIDItem item) {
        long now = Utils.now().getTime();
        long maxSessionTime = 1800000L;
        return now - item.created <= 1800000L;
    }

    public synchronized void kontrolujProsle() {
        ArrayList<String> kOdstraneni = new ArrayList<String>(this.cache.size());
        for (UUIDItem item : this.cache.values()) {
            if (this.isUUIDValid(item)) continue;
            kOdstraneni.add(item.key);
        }
        for (String uuid : kOdstraneni) {
            this.cache.remove(uuid);
        }
    }
}

