/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.service;

import com.google.common.eventbus.EventBus;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import cz.kpsys.common.IniConstants;
import cz.kpsys.common.Licensing;
import cz.kpsys.db.DatabaseEngine;
import cz.kpsys.db.DbCache2;
import cz.kpsys.kpwin2.rest.ConfigurationUtils;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import cz.kpsys.kpwin2.services.ZaznamyNarodkaService;
import cz.kpsys.marc.Field;
import cz.kpsys.marc.Record;
import cz.kpsys.marc.SubField;
import cz.kpsys.service.DateConversions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.Base64;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    public static final String INTERNAL_BUILD = "Internal build";
    public static final int DATE_TYPE_TODAY = 1;
    public static final int DATE_TYPE_NOW = 2;
    public static final String VERBIS_AGENT = "KPSYS Verbis AS HTTP client";
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static java.util.Date mockedDate = null;
    private static final EventBus eventBus = new EventBus("system");
    public static final java.util.Date pocatekEpochy = new java.util.Date(0L);
    public static final DateTimeFormatter dtfSQLDate = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    public static final DateTimeFormatter dtfSQLHumanDate = DateTimeFormatter.ofPattern("d.M.yyyy");
    public static final DateTimeFormatter dtfSQLDateTime = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss.SSS");
    public static final DateTimeFormatter dtfDateHour = DateTimeFormatter.ofPattern("d.M.y H");
    public static final DateTimeFormatter dtfTextTimestamp = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    public static final DateTimeFormatter dtfDateTimestamp = DateTimeFormatter.ofPattern("yyyyMMdd");
    static PropertiesConfiguration pcGitProperties = new PropertiesConfiguration();
    private static boolean propertiesLoaded = false;
    public static java.util.Date POCATEK_EPOCHY_DATE = null;

    @Deprecated
    public static String computeSessionID(long id) {
        return Long.toHexString(id);
    }

    public static String parseAttribute(Document doc, String tagName, String attributeName, String defaultValue) {
        Attribute attr;
        Element node = (Element)doc.getRootElement().selectSingleNode(tagName);
        if (node != null && (attr = node.attribute(attributeName)) != null) {
            String value = attr.getValue();
            if (value == null) {
                return defaultValue;
            }
            return value;
        }
        return defaultValue;
    }

    public static String parseTag(Document doc, String tagName, String defaultValue) {
        String value = Utils.parseTag((Document)doc, (String)tagName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String parseTag(Document doc, String tagName) {
        Node node = doc.getRootElement().selectSingleNode(tagName);
        if (node != null) {
            String VALUE = node.getText();
            return VALUE;
        }
        return null;
    }

    public static boolean blankInteger(Integer i) {
        return i == null || i == 0;
    }

    public static boolean blankLong(Long l) {
        return l == null || l == 0L;
    }

    public static void setPsValue(PreparedStatement ps, int index, Long l) throws SQLException {
        if (l != null) {
            ps.setLong(index, l);
        } else {
            ps.setNull(index, -5);
        }
    }

    public static void setPsValue(PreparedStatement ps, int index, Integer i) throws SQLException {
        if (i != null) {
            ps.setInt(index, i);
        } else {
            ps.setNull(index, 4);
        }
    }

    public static void setPsValue(PreparedStatement ps, int index, String s) throws SQLException {
        ps.setString(index, s);
    }

    public static void setPsValue(PreparedStatement ps, int index, Short s) throws SQLException {
        if (s != null) {
            ps.setShort(index, s);
        } else {
            ps.setNull(index, 5);
        }
    }

    public static void setPsValue(PreparedStatement ps, int index, java.util.Date d) throws SQLException {
        if (d != null) {
            ps.setDate(index, new Date(d.getTime()));
        } else {
            ps.setNull(index, 91);
        }
    }

    public static SimpleDateFormat sdfSQLDate() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }

    public static SimpleDateFormat sdfHumanDate() {
        return new SimpleDateFormat("d.M.yyyy");
    }

    public static SimpleDateFormat sdfSQLDateTime() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    }

    public static SimpleDateFormat sdfTextTimestamp() {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS");
    }

    public static SimpleDateFormat sdfDateTimestamp() {
        return new SimpleDateFormat("yyyyMMdd");
    }

    public static SimpleDateFormat sdfSQLDateTimeNoSecs() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm");
    }

    public static java.util.Date anyDate2UtilDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return new java.util.Date(date.getTime());
    }

    public static Date util2sqlDate(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public static java.util.Date sql2utilDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.util.Date(date.getTime());
    }

    public static String xmlEscape(String s) {
        return StringEscapeUtils.escapeXml10((String)s);
    }

    public static String todayNowString(int DATE_TYPE, DatabaseEngine dbe) {
        switch (DATE_TYPE) {
            case 1: {
                if (dbe == DatabaseEngine.FIREBIRD) {
                    return "'TODAY'";
                }
                if (dbe == DatabaseEngine.ORACLE) {
                    return "TRUNC(SYSDATE)";
                }
                dbe.unknownEngine();
            }
            case 2: {
                if (dbe == DatabaseEngine.FIREBIRD) {
                    return "'NOW'";
                }
                if (dbe == DatabaseEngine.ORACLE) {
                    return "SYSDATE";
                }
                dbe.unknownEngine();
            }
        }
        throw new IllegalArgumentException("neplatny argument DATE_TYPE");
    }

    public static java.util.Date today() {
        return DateConversions.localDate2utilDate((LocalDate)LocalDate.now());
    }

    public static java.util.Date yesterday() {
        return DateConversions.localDate2utilDate((LocalDate)LocalDate.now().plusDays(-1L));
    }

    public static Date sqlToday() {
        return new Date(Utils.today().getTime());
    }

    public static int daysBetween(java.util.Date dateBefore, java.util.Date dateAfter) {
        LocalDateTime dt1 = DateConversions.utilDate2localDateTime((java.util.Date)dateBefore);
        LocalDateTime dt2 = DateConversions.utilDate2localDateTime((java.util.Date)dateAfter);
        return (int)ChronoUnit.DAYS.between(dt1, dt2);
    }

    public static int daysBetweenAbs(java.util.Date date1, java.util.Date date2) {
        return Math.abs(Utils.daysBetween((java.util.Date)date1, (java.util.Date)date2));
    }

    public static String prevedNaCisteSQL(String sqlCommandFormatovany, DatabaseEngine databaseEngine) {
        return sqlCommandFormatovany.replace("^", databaseEngine == DatabaseEngine.FIREBIRD ? ";" : "").replace("\u16cf", "^").trim();
    }

    public static boolean internalBuild() {
        try {
            if (Utils.getVersionString().contains("Internal build")) {
                return true;
            }
        }
        catch (Exception e) {
            logger.info("zjistovani internity buildu", (Throwable)e);
        }
        return false;
    }

    public static PropertiesConfiguration loadVersionProperties() {
        block3: {
            if (!propertiesLoaded) {
                try {
                    InputStream is = Utils.class.getClassLoader().getResourceAsStream("git.properties");
                    propertiesLoaded = true;
                    pcGitProperties = ConfigurationUtils.createInputStreamConfiguration((InputStream)is);
                }
                catch (Exception e) {
                    if (KPWINServiceApplication.internalBuild()) break block3;
                    logger.warn("problem pri zjistovani verze", (Throwable)e);
                }
            }
        }
        return pcGitProperties;
    }

    public static XStream obtainTaskQueueXStream() {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStream.alias("r", Record.class);
        xStream.alias("f", Field.class);
        xStream.alias("sf", SubField.class);
        return xStream;
    }

    public static XStream obtainNarodkaCacheXStream() {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStream.alias("r", Record.class);
        xStream.alias("f", Field.class);
        xStream.alias("sf", SubField.class);
        xStream.alias("ns", ZaznamyNarodkaService.class);
        xStream.alias("zaz", ZaznamyNarodkaService.CacheZaznam.class);
        return xStream;
    }

    public static XStream obtainXStream() {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        return xStream;
    }

    public static void printMapList(List<Map<String, Object>> listMap) {
        try {
            FileWriter fw = new FileWriter(new File("/tmp/log_denik.txt"));
            StringBuilder sb = new StringBuilder();
            for (Map<String, Object> map : listMap) {
                sb.setLength(0);
                for (String key : map.keySet()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(map.get(key));
                }
                String radek = sb.toString();
                System.err.println(radek);
                fw.write(radek + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            logger.error("selhani", (Throwable)e);
        }
    }

    public static String decodeString(String string) {
        return new String(Base64.decodeBase64((String)string), StandardCharsets.US_ASCII);
    }

    public static String urlEncode(String input) {
        return URLEncoder.encode(input, StandardCharsets.UTF_8);
    }

    public static String concat(String s1, String s2, String spojovnik) {
        boolean s1Blank = StringUtils.isBlank((CharSequence)s1);
        boolean s2Blank = StringUtils.isBlank((CharSequence)s2);
        StringBuilder sb = new StringBuilder();
        if (!s1Blank) {
            sb.append(s1);
            if (StringUtils.isNotBlank((CharSequence)spojovnik) && !s2Blank) {
                sb.append(spojovnik);
            }
            if (!s2Blank) {
                sb.append(s2);
            }
        } else if (!s2Blank) {
            sb.append(s2);
        }
        return sb.toString();
    }

    public static String prepareAppServerInfo() {
        StringBuilder sb = new StringBuilder();
        String serial = DbCache2.queryINIFlag((String)IniConstants.SEKCE_KPWIN(), (String)"SERIAL", null, null);
        sb.append("info o instanci AS: \n");
        sb.append("------------------- \n\n");
        sb.append("serial: " + serial + "\n");
        sb.append("verze systemu: " + Licensing.verbisVersion() + "\n");
        sb.append("verze AS: " + KPWINServiceApplication.versionString + "\n");
        sb.append("port: " + KPWINServiceApplication.configuration.getPortString() + "\n");
        sb.append("db_url: " + KPWINServiceApplication.dbConfig.jdbcURL() + "\n");
        sb.append("cas: " + Utils.sdfSQLDateTime().format(Utils.now()) + "\n");
        String localIp = Utils.zjistiLokalniIP();
        String publicIp = Utils.zjistiPublicIp();
        sb.append("local ip: " + localIp + "\n");
        sb.append("public ip: " + publicIp + "\n");
        String knihovna = StringUtils.join((Object[])new Object[]{Utils.ku((String)"NAZEV"), Utils.ku((String)"MISTO"), Utils.ku((String)"ULICE"), Utils.ku((String)"PSC"), Utils.ku((String)"SIGLA"), Utils.ku((String)"EMAIL")}, (String)" / ");
        sb.append("knihovna: " + knihovna + "\n");
        return sb.toString();
    }

    private static String ku(String udaj) {
        return DbCache2.queryINIFlag((String)"KNIHOVNA", (String)udaj, null, null);
    }

    private static String zjistiLokalniIP() {
        StringBuilder sb = new StringBuilder();
        try {
            Enumeration<NetworkInterface> netEnum = NetworkInterface.getNetworkInterfaces();
            while (netEnum.hasMoreElements()) {
                NetworkInterface n = netEnum.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    sb.append(" " + i.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            logger.warn("problem pri zjistovani lokalni IP", (Throwable)e);
        }
        return sb.toString();
    }

    private static String zjistiPublicIp() {
        try {
            URL url = new URL("http://update.kpsys.cz/ip.php");
            URLConnection conn = url.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String inputLine = br.readLine();
            br.close();
            return inputLine;
        }
        catch (Throwable e) {
            logger.warn("nepodarilo se zjistit externi IP", e);
            return "<nezname>";
        }
    }

    public static java.util.Date now() {
        return Objects.requireNonNullElseGet(mockedDate, java.util.Date::new);
    }

    public static Date sqlNow() {
        return Utils.util2sqlDate((java.util.Date)Utils.now());
    }

    public static Timestamp sqlNowTimestamp() {
        return new Timestamp(Utils.now().getTime());
    }

    public static void forceTestingDate() throws ParseException {
        mockedDate = Utils.sdfSQLDate().parse("1.4.2017");
    }

    public static void forceTestingDate(String date) throws ParseException {
        mockedDate = Utils.sdfSQLDate().parse(date);
    }

    public static void forceRealDate() {
        mockedDate = null;
    }

    public static void forceTestingDate(int days) throws ParseException {
        mockedDate = new java.util.Date(Utils.sdfSQLDate().parse("1.4.2017").getTime() + (long)(86400000 * days));
    }

    public static void remoteLogError(String uuid, String message, Exception e) {
        logger.error("UUID: " + uuid + " : " + message, (Throwable)e);
    }

    public static void logMemoryUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Heap=" + ManagementFactory.getMemoryMXBean().getHeapMemoryUsage());
        sb.append("/NonHeap=" + ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
        sb.append(" / ");
        List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : beans) {
            sb.append(memoryPoolMXBean.getName() + "=" + memoryPoolMXBean.getUsage() + "/");
        }
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            sb.append(garbageCollectorMXBean.getName() + "=" + garbageCollectorMXBean.getCollectionCount() + "/");
        }
        logger.warn("MEMORY USAGE " + sb);
    }

    public static void postEvent(Object o) {
        eventBus.post(o);
    }

    public static void registerEventHandler(Object handler) {
        eventBus.register(handler);
    }

    public static void unregisterEventHandler(Object handler) {
        eventBus.unregister(handler);
    }

    public static String speedConstant() {
        String s1 = "UVDbU5TalBlMzU1MmdMdDk";
        String s2 = "b2ZaNFlyN1czN042VWxha";
        return Utils.decodeString((String)"b2ZaNFlyN1czN042VWxhaUVDbU5TalBlMzU1MmdMdDk=");
    }

    public static List<String> split(String s, String separator) {
        String[] array = StringUtils.split((String)s, (String)separator);
        return Arrays.asList(array);
    }

    public static String prettyPrintXML(Document doc) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        StringWriter stringWriter = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
        try {
            writer.write(doc);
        }
        catch (IOException e) {
            logger.error("selhani", (Throwable)e);
        }
        return stringWriter.toString();
    }

    public static int buildNumber() {
        return pcGitProperties.getInt("build.number", 99999);
    }

    public static String getVersionString() {
        int buildNumber = Utils.buildNumber();
        String commitId = pcGitProperties.getString("git.commit.id.abbrev");
        String gitCommitTime = pcGitProperties.getString("git.commit.time");
        return String.format("%s (%s - %s)", buildNumber, commitId, gitCommitTime);
    }

    public static void notImplementedYet() {
        throw new NotImplementedException("dodelat");
    }

    static {
        try {
            POCATEK_EPOCHY_DATE = Utils.sdfSQLDate().parse("1.1.1970");
        }
        catch (ParseException e) {
            logger.error("nepodarilo se stanovit pocatek epochy", (Throwable)e);
        }
    }
}

