/*
 * Decompiled with CFR 0.152.
 */
package marc;

import marc.MARCException;
import marc.USmarcField;

public class USmarc {
    public static final byte RECORD_TERMINATOR = 29;
    public USmarcField[] fields;

    public USmarc(byte[] encoding) throws MARCException {
        if (encoding.length < 24) {
            throw new MARCException("Encoding too short");
        }
        String logical_record_length = new String(encoding, 0, 0, 5);
        if (Integer.parseInt(logical_record_length) != encoding.length) {
            throw new MARCException("Encoding length invalid");
        }
        int data_base_address = Integer.parseInt(new String(encoding, 0, 12, 5));
        if (data_base_address < 24 || encoding.length < data_base_address) {
            throw new MARCException("Encoding data base address invalid");
        }
        if (encoding[10] != 50) {
            throw new MARCException("Encoding indicator count != 2");
        }
        if (encoding[11] != 50) {
            throw new MARCException("Encoding subfield code count != 2");
        }
        int num_fields = (data_base_address - 1 - 24) / 12;
        if (encoding[num_fields * 12 + 24] != 30) {
            throw new MARCException("Encoding missing directory terminator");
        }
        this.fields = new USmarcField[num_fields];
        for (int index = 0; index < num_fields; ++index) {
            int offset = index * 12 + 24;
            String tag = new String(encoding, 0, offset, 3);
            int len = Integer.parseInt(new String(encoding, 0, offset + 3, 4));
            int start = Integer.parseInt(new String(encoding, 0, offset + 7, 5));
            this.fields[index] = new USmarcField(tag, len, encoding, data_base_address + start);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int index = 0; index < this.fields.length; ++index) {
            buf.append(this.fields[index]);
            buf.append('\n');
        }
        return new String(buf);
    }

    public static void main(String[] argv) {
        String enc_str = "00831nam  22001939b 4504008004100000019001400041099001900055100002600074245014100100260003000241300002500271504002700296600004500323650007400368650004900442650007400491700002500565920004700590870403c1963    enk           000 0 eng u  aQU0502370  aPE26bS5 19631 aBrown, Arthur,d1921-10aEarly English and Norse studies :bpresented to Hugh Smith in honour of his sixtieth birthday /cedited by Arthur Brown and Peter Foote.  aLondon :bMethuen,c1963.  a225p :bill ;.c23cm.  aIncludes bibliography10\naSmith, A Hq(Albert Hugh),d1903-1967.00aEnglish literatureyMiddle English, 1100-1500xHistory and criticism.00aOld Norse literaturexHistory and criticism.00aEnglish literatureyOld English, ca 450-1100.xHistory and criticism.1 aFoote, Peter,d1924-  aWarehouse Ask at DeskbAA67430 cAVAILABLE..";
        byte[] enc = new byte[enc_str.length()];
        for (int x = 0; x < enc_str.length(); ++x) {
            enc[x] = (byte)enc_str.charAt(x);
        }
        try {
            USmarc record = new USmarc(enc);
            System.out.println(record);
        }
        catch (MARCException e) {
            System.out.println("Error: " + e);
        }
    }
}

