/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.databeans;

import org.jafer.exception.JaferException;
import org.jafer.interfaces.Databean;
import org.jafer.interfaces.Present;
import org.jafer.interfaces.Search;
import org.jafer.record.Field;
import org.jafer.util.xml.DOMFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ActiveBean
extends Thread {
    private int first;
    private int last;
    private Databean bean;
    private Node query;
    private Logger logger = LoggerFactory.getLogger((String)"org.jafer.databeans");

    ActiveBean() {
    }

    public void setLimits(int first, int last) {
        this.first = first;
        this.last = last;
    }

    public boolean containsRecord(int rec) {
        return rec >= this.first && rec <= this.last;
    }

    public Databean getDatabean() {
        return this.bean;
    }

    public void setDatabean(Databean bean) {
        this.bean = bean;
    }

    public void setQuery(Node query) {
        Document doc = DOMFactory.newDocument();
        this.query = doc.importNode(query, true);
    }

    public Node getQuery() {
        return this.query;
    }

    public Field getRecord(int rec, String schema) throws JaferException {
        ((Present)this.bean).setRecordSchema(schema);
        ((Present)this.bean).setRecordCursor(rec - this.first + 1);
        return ((Present)this.bean).getCurrentRecord();
    }

    @Override
    public void run() {
        try {
            this.first = 0;
            this.last = 0;
            int results = ((Search)this.bean).submitQuery(this.query);
            this.logger.debug("Search on " + this.getName() + " found " + Integer.toString(results) + " sanity check " + ((Search)this.bean).getNumberOfResults());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

