/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.databeans;

import java.net.URL;
import javax.xml.transform.Templates;
import org.jafer.databeans.Adaptor;
import org.jafer.exception.JaferException;
import org.jafer.interfaces.Databean;
import org.jafer.interfaces.DatabeanFactory;
import org.jafer.util.xml.XMLTransformer;

public abstract class AdaptorFactory
extends DatabeanFactory {
    private String styleSheetPath;
    private String sourceSchema;
    private String targetSchema;
    private DatabeanFactory databeanFactory;

    public Databean getDatabean(Adaptor adaptor) {
        adaptor.setDatabean(this.databeanFactory.getDatabean());
        if (this.getTransform() != null) {
            Templates template = null;
            try {
                URL resource = this.getClass().getClassLoader().getResource(this.getTransform());
                template = XMLTransformer.createTemplate((URL)resource);
            }
            catch (JaferException ex) {
                System.out.println("AdaptorFactory; cannot create Templates object");
            }
            adaptor.setTransform(template);
            adaptor.setSourceSchema(this.getSourceSchema());
            adaptor.setTargetSchema(this.getTargetSchema());
        }
        return adaptor;
    }

    public void setTransform(String styleSheetPath) {
        this.styleSheetPath = styleSheetPath;
    }

    public String getTransform() {
        return this.styleSheetPath;
    }

    public void setSourceSchema(String sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    public String getSourceSchema() {
        return this.sourceSchema;
    }

    public void setTargetSchema(String targetSchema) {
        this.targetSchema = targetSchema;
    }

    public String getTargetSchema() {
        return this.targetSchema;
    }

    public void setDatabeanFactory(DatabeanFactory databeanFactory) {
        this.databeanFactory = databeanFactory;
    }

    public DatabeanFactory getDatabeanFactory() {
        return this.databeanFactory;
    }
}

