/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.databeans;

import javax.xml.transform.Templates;
import org.jafer.databeans.Adaptor;
import org.jafer.exception.JaferException;
import org.jafer.interfaces.Present;
import org.jafer.record.Field;
import org.jafer.util.xml.XMLTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RecordAdaptor
extends Adaptor {
    public Field getCurrentRecord() throws JaferException {
        Element recordRoot = (Element)((Present)this.getDatabean()).getCurrentRecord().getRoot();
        String sourceSchema = this.getSourceSchema();
        String targetSchema = this.getTargetSchema();
        if (!recordRoot.hasAttribute("schema")) {
            throw new JaferException("schema attribute not found in XMLRecord root");
        }
        String recordSchema = recordRoot.getAttribute("schema");
        if (sourceSchema == null) {
            recordRoot = this.transformRecord(recordRoot, targetSchema);
        } else if (recordSchema.equalsIgnoreCase(sourceSchema)) {
            recordRoot = this.transformRecord(recordRoot, targetSchema);
        }
        return new Field((Node)recordRoot, recordRoot.getFirstChild());
    }

    private Element transformRecord(Element recordRoot, String targetSchema) throws JaferException {
        Node record = recordRoot.getFirstChild();
        recordRoot.removeChild(record);
        record = XMLTransformer.transform((Node)record, (Templates)this.getTransform());
        recordRoot.appendChild(record);
        if (targetSchema != null) {
            recordRoot.setAttribute("schema", targetSchema);
        }
        return recordRoot;
    }
}

