/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.query;

import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.query.QueryBuilder;
import org.jafer.query.QueryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryParser {
    private QueryBuilder builder;
    private Document document;

    QueryParser(QueryBuilder builder, Document document) {
        this.builder = builder;
        this.document = document;
    }

    Node parseQuery(Node inputNode) throws QueryException {
        Node normalizedNode = this.normalize(inputNode);
        Node outputNode = this.processNode(normalizedNode);
        if (outputNode.getNodeName().equalsIgnoreCase("not")) {
            Element andNot = this.document.createElement("andNot");
            andNot.appendChild(this.makeDummyNode());
            andNot.appendChild(outputNode.getFirstChild());
            return andNot;
        }
        return outputNode;
    }

    private Node normalize(Node node) throws QueryException {
        Node returnNode;
        String name = node.getNodeName();
        if (name.equalsIgnoreCase("model") || name.equalsIgnoreCase("semantic") || name.equalsIgnoreCase("relation") || name.equalsIgnoreCase("position") || name.equalsIgnoreCase("structure") || name.equalsIgnoreCase("truncation") || name.equalsIgnoreCase("completeness")) {
            String text = node.getFirstChild().getNodeValue().trim();
            node.getFirstChild().setNodeValue(text);
            returnNode = node.cloneNode(true);
        } else {
            returnNode = node.cloneNode(false);
            if (node.hasChildNodes()) {
                NodeList list = node.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    if (list.item(i).getNodeType() == 3) continue;
                    returnNode.appendChild(this.normalize(list.item(i)));
                }
            }
        }
        return returnNode;
    }

    private Node processNode(Node node) throws QueryException {
        String nodeName = node.getNodeName();
        if (nodeName.equalsIgnoreCase("constraintModel")) {
            return this.checkConstraintModel(node);
        }
        if (nodeName.equalsIgnoreCase("and")) {
            Node firstChild = this.processNode(node.getFirstChild());
            Node secondChild = this.processNode(node.getLastChild());
            Element returnNode = this.document.createElement("and");
            returnNode.appendChild(firstChild);
            returnNode.appendChild(secondChild);
            return this.processAndNode((Node)returnNode);
        }
        if (nodeName.equalsIgnoreCase("or")) {
            Node firstChild = this.processNode(node.getFirstChild());
            Node secondChild = this.processNode(node.getLastChild());
            Element returnNode = this.document.createElement("or");
            returnNode.appendChild(firstChild);
            returnNode.appendChild(secondChild);
            return this.processOrNode((Node)returnNode);
        }
        if (nodeName.equalsIgnoreCase("not")) {
            Node child = this.processNode(node.getFirstChild());
            Element returnNode = this.document.createElement("not");
            returnNode.appendChild(child);
            return returnNode;
        }
        throw new QueryException("Node expected: \"constraintModel/AND/OR/NOT\", node found: " + nodeName);
    }

    private Node checkConstraintModel(Node cM) throws QueryException {
        NodeList list = cM.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeName().equalsIgnoreCase("constraint")) {
                NodeList constraintList = list.item(i).getChildNodes();
                for (int j = 0; j < constraintList.getLength(); ++j) {
                    String type = constraintList.item(j).getNodeName();
                    try {
                        Config.getAttributeType((String)type);
                        continue;
                    }
                    catch (JaferException ex) {
                        throw new QueryException("invalid Bib1 attribute type: " + type);
                    }
                }
                continue;
            }
            if (list.item(i).getNodeName().equalsIgnoreCase("model")) continue;
            throw new QueryException("Unexpected node found in constraintModel node: " + list.item(i).getNodeName());
        }
        return cM;
    }

    private Node processAndNode(Node node) {
        if (node.getFirstChild().getNodeName().equalsIgnoreCase("not") && node.getLastChild().getNodeName().equalsIgnoreCase("not")) {
            Node firstChild = node.getFirstChild().getFirstChild();
            Node secondChild = node.getLastChild().getFirstChild();
            Element or = this.document.createElement("or");
            or.appendChild(firstChild);
            or.appendChild(secondChild);
            Element not = this.document.createElement("not");
            not.appendChild(or);
            return not;
        }
        if (node.getFirstChild().getNodeName().equalsIgnoreCase("not")) {
            Node firstChild = node.getLastChild();
            Node secondChild = node.getFirstChild().getFirstChild();
            Element andNot = this.document.createElement("andNot");
            andNot.appendChild(firstChild);
            andNot.appendChild(secondChild);
            return andNot;
        }
        if (node.getLastChild().getNodeName().equalsIgnoreCase("not")) {
            Node firstChild = node.getFirstChild();
            Node secondChild = node.getLastChild().getFirstChild();
            Element andNot = this.document.createElement("andNot");
            andNot.appendChild(firstChild);
            andNot.appendChild(secondChild);
            return andNot;
        }
        return node;
    }

    private Node processOrNode(Node node) {
        if (node.getFirstChild().getNodeName().equalsIgnoreCase("not") && node.getLastChild().getNodeName().equalsIgnoreCase("not")) {
            Node firstChild = node.getFirstChild().getFirstChild();
            Node secondChild = node.getLastChild().getFirstChild();
            Element and = this.document.createElement("and");
            and.appendChild(firstChild);
            and.appendChild(secondChild);
            Element not = this.document.createElement("not");
            not.appendChild(and);
            return not;
        }
        if (node.getFirstChild().getNodeName().equalsIgnoreCase("not")) {
            Node firstChild = node.getFirstChild().getFirstChild();
            Node secondChild = node.getLastChild();
            Element andNot = this.document.createElement("andNot");
            andNot.appendChild(firstChild);
            andNot.appendChild(secondChild);
            Element not = this.document.createElement("not");
            not.appendChild(andNot);
            return not;
        }
        if (node.getLastChild().getNodeName().equalsIgnoreCase("not")) {
            Node firstChild = node.getLastChild().getFirstChild();
            Node secondChild = node.getFirstChild();
            Element andNot = this.document.createElement("andNot");
            andNot.appendChild(firstChild);
            andNot.appendChild(secondChild);
            Element not = this.document.createElement("not");
            not.appendChild(andNot);
            return not;
        }
        return node;
    }

    private Node makeDummyNode() throws QueryException {
        int[][] attr = new int[][]{{1, 1016}, {2, 103}};
        String term = "dummy term";
        this.builder.dummyNodePresent = true;
        return this.builder.getNode((int[][])attr, term);
    }
}

