/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.query;

import asn1.ASN1Integer;
import asn1.ASN1Null;
import asn1.ASN1ObjectIdentifier;
import asn1.ASN1OctetString;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.query.QueryBuilder;
import org.jafer.query.QueryException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import z3950.v3.AttributeElement;
import z3950.v3.AttributeElement_attributeValue;
import z3950.v3.AttributeList;
import z3950.v3.AttributeSetId;
import z3950.v3.AttributesPlusTerm;
import z3950.v3.Operand;
import z3950.v3.Operator;
import z3950.v3.RPNQuery;
import z3950.v3.RPNStructure;
import z3950.v3.RPNStructure_rpnRpnOp;
import z3950.v3.Term;

public class XMLRPNQuery {
    private String encoding = StandardCharsets.UTF_8.toString();

    public XMLRPNQuery(String encoding) {
        this.encoding = encoding;
    }

    public XMLRPNQuery() {
    }

    public RPNQuery getRPNQuery(Node domQuery) throws QueryException {
        RPNStructure structure = this.processNode(domQuery);
        RPNQuery rpnQuery = new RPNQuery();
        rpnQuery.s_rpn = structure;
        rpnQuery.s_attributeSet = new AttributeSetId();
        rpnQuery.s_attributeSet.value = new ASN1ObjectIdentifier(Config.convertSyntax((String)Config.getAttributeSetSyntax()));
        return rpnQuery;
    }

    private RPNStructure processNode(Node node) throws QueryException {
        String nodeName = node.getNodeName();
        if (nodeName.equalsIgnoreCase("constraintModel")) {
            return this.processConstraintModel(node);
        }
        RPNStructure rpn = new RPNStructure();
        rpn.c_rpnRpnOp = new RPNStructure_rpnRpnOp();
        rpn.c_rpnRpnOp.s_op = new Operator();
        if (nodeName.equalsIgnoreCase("and")) {
            rpn.c_rpnRpnOp.s_op.c_and = new ASN1Null();
        } else if (nodeName.equalsIgnoreCase("or")) {
            rpn.c_rpnRpnOp.s_op.c_or = new ASN1Null();
        } else if (nodeName.equalsIgnoreCase("andNot")) {
            rpn.c_rpnRpnOp.s_op.c_and_not = new ASN1Null();
        }
        rpn.c_rpnRpnOp.s_rpn1 = this.processNode(node.getFirstChild());
        rpn.c_rpnRpnOp.s_rpn2 = this.processNode(node.getLastChild());
        return rpn;
    }

    public RPNStructure processConstraintModel(Node cM) throws QueryException {
        int[] attributeValues = new int[]{0, 0, 0, 0, 0, 0, 0};
        Node constraint = cM.getFirstChild();
        NodeList list = constraint.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            try {
                int attribute = Config.getAttributeType((String)child.getNodeName());
                attributeValues[attribute] = Integer.parseInt(child.getFirstChild().getNodeValue());
                continue;
            }
            catch (NumberFormatException n) {
                throw new QueryException("Invalid use attribute value submitted: " + child.getFirstChild().getNodeValue());
            }
            catch (JaferException e) {
                throw new QueryException("Invalid use attribute submitted: " + child.getNodeName());
            }
        }
        AttributeElement[] ae = new AttributeElement[constraint.getChildNodes().getLength()];
        int j = 0;
        for (int i = 1; i < attributeValues.length; ++i) {
            if (attributeValues[i] == 0) continue;
            ae[j] = new AttributeElement();
            ae[j].s_attributeType = new ASN1Integer(i);
            ae[j].s_attributeValue = new AttributeElement_attributeValue();
            ae[j].s_attributeValue.c_numeric = new ASN1Integer(attributeValues[i]);
            ++j;
        }
        Node model = cM.getLastChild();
        String term = model.getFirstChild().getNodeValue();
        Operand operand = new Operand();
        operand.c_attrTerm = new AttributesPlusTerm();
        operand.c_attrTerm.s_attributes = new AttributeList();
        operand.c_attrTerm.s_attributes.value = ae;
        operand.c_attrTerm.s_term = new Term();
        if ("latin-1".equalsIgnoreCase(this.encoding)) {
            this.encoding = "iso-8859-1";
        }
        try {
            operand.c_attrTerm.s_term.c_general = new ASN1OctetString(term.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new QueryException("nepodporovane kodovani ZSERVER " + this.encoding);
        }
        RPNStructure rpn = new RPNStructure();
        rpn.c_op = operand;
        return rpn;
    }

    public Node getXMLQuery(RPNQuery query) throws QueryException {
        QueryBuilder builder = new QueryBuilder();
        Node queryNode = this.processStructure(query.s_rpn, builder);
        return queryNode;
    }

    private Node processStructure(RPNStructure structure, QueryBuilder builder) throws QueryException {
        Node queryNode = null;
        RPNStructure_rpnRpnOp thingy = structure.c_rpnRpnOp;
        if (thingy != null) {
            if (thingy.s_op.c_and != null) {
                queryNode = builder.and(this.processStructure(thingy.s_rpn1, builder), this.processStructure(thingy.s_rpn2, builder));
            } else if (thingy.s_op.c_or != null) {
                queryNode = builder.or(this.processStructure(thingy.s_rpn1, builder), this.processStructure(thingy.s_rpn2, builder));
            } else if (thingy.s_op.c_and_not != null) {
                queryNode = builder.and(this.processStructure(thingy.s_rpn1, builder), builder.not(this.processStructure(thingy.s_rpn2, builder)));
            }
        } else {
            queryNode = this.buildConstraintModel(structure, builder);
        }
        return queryNode;
    }

    public Node buildConstraintModel(RPNStructure rpn, QueryBuilder builder) throws QueryException {
        HashMap<Integer, Integer> attributesList = new HashMap<Integer, Integer>();
        int maxAttributeNumber = 0;
        for (int i = 0; i < rpn.c_op.c_attrTerm.s_attributes.value.length; ++i) {
            int atributeType = rpn.c_op.c_attrTerm.s_attributes.value[i].s_attributeType.get();
            if (atributeType > maxAttributeNumber) {
                maxAttributeNumber = atributeType;
            }
            attributesList.put(atributeType - 1, rpn.c_op.c_attrTerm.s_attributes.value[i].s_attributeValue.c_numeric.get());
        }
        int[] attributes = new int[maxAttributeNumber];
        for (Integer i : attributesList.keySet()) {
            attributes[i.intValue()] = (Integer)attributesList.get(i);
        }
        String term = rpn.c_op.c_attrTerm.s_term.c_general.get(this.encoding);
        Node cM = builder.getNode(attributes, term);
        return cM;
    }
}

