/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import asn1.ASN1Exception;
import asn1.BEREncoding;
import org.jafer.conf.Config;
import org.jafer.record.DataObject;
import org.jafer.record.RecordException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import z3950.v3.DefaultDiagFormat;

public class Diagnostic
extends DataObject {
    public Diagnostic(String dbName, BEREncoding ber) {
        super(dbName, ber);
    }

    public Diagnostic(String dbName, Node root) {
        super(dbName, root);
    }

    private DefaultDiagFormat getDefaultDiagFormat() throws RecordException {
        DefaultDiagFormat defaultDiagFormat = null;
        try {
            defaultDiagFormat = new DefaultDiagFormat(this.getBER(), true);
        }
        catch (ASN1Exception e) {
            throw new RecordException("ASN1Exception processing Diagnostic; " + e.toString(), (Throwable)e);
        }
        return defaultDiagFormat;
    }

    public int getCondition() throws RecordException {
        int condition = 0;
        try {
            condition = this.getDefaultDiagFormat().s_condition.get();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return condition;
    }

    public String getAddInfo() throws RecordException {
        String addInfo = "";
        try {
            if (this.getDefaultDiagFormat().s_addinfo != null && this.getDefaultDiagFormat().s_addinfo.c_v2Addinfo != null) {
                addInfo = this.getDefaultDiagFormat().s_addinfo.c_v2Addinfo.get();
            } else if (this.getDefaultDiagFormat().s_addinfo != null && this.getDefaultDiagFormat().s_addinfo.c_v3Addinfo != null) {
                addInfo = this.getDefaultDiagFormat().s_addinfo.c_v3Addinfo.value.get();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return addInfo;
    }

    public Node getXML(Document document) throws RecordException {
        Element root = document.createElement("diagnostic");
        Element condition = document.createElement("condition");
        condition.appendChild(document.createTextNode(String.valueOf(this.getCondition())));
        root.appendChild(condition);
        if (this.getAddInfo() != null) {
            Element additionalInfo = document.createElement("additionalInformation");
            additionalInfo.appendChild(document.createTextNode(this.getAddInfo()));
            root.appendChild(additionalInfo);
        }
        return root;
    }

    public BEREncoding getBER() throws RecordException {
        if (super.getBER() != null) {
            return super.getBER();
        }
        return null;
    }

    public String toString() {
        String s = null;
        try {
            s = "Diagnostic (condition = " + this.getCondition() + ") ";
            s = s + Config.getBib1Diagnostic((int)this.getCondition());
            s = s + (String)(this.getAddInfo().equals("") ? "" : "; additional info: " + this.getAddInfo());
        }
        catch (RecordException recordException) {
            // empty catch block
        }
        return s;
    }
}

