/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import org.apache.xpath.NodeSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Field {
    private Node recordRoot;
    private Node recordFragment;

    public Field(Node recordRoot, Node recordFragment) {
        this.recordRoot = recordRoot;
        this.recordFragment = recordFragment;
    }

    public Node getRoot() {
        return this.recordRoot;
    }

    public Node getXML() {
        return this.recordFragment;
    }

    public String getRecordSyntax() {
        if (this.recordRoot == null) {
            return "unknown";
        }
        return ((Element)this.recordRoot).getAttribute("syntax");
    }

    public String getDataBaseName() {
        if (this.recordRoot == null) {
            return "unknown";
        }
        return ((Element)this.recordRoot).getAttribute("dbName");
    }

    public String getRecordSchema() {
        if (this.recordRoot == null) {
            return "unknown";
        }
        return ((Element)this.recordRoot).getAttribute("schema");
    }

    public String getValue() {
        String data = "";
        if (this.recordFragment == null) {
            return data;
        }
        if (this.recordFragment.hasChildNodes() && this.recordFragment.getFirstChild().getNodeType() == 3) {
            data = this.recordFragment.getFirstChild().getNodeValue();
        }
        return data;
    }

    public String getName() {
        return ((Element)this.recordFragment).getTagName();
    }

    public Field[] get(String fieldName) {
        return this.get(fieldName, new String[0]);
    }

    public Field[] get(String fieldName, String attributeName, String attributeValue) {
        String[] attributeProfile = new String[]{attributeName, attributeValue};
        return this.get(fieldName, attributeProfile);
    }

    public Field[] get(String fieldName, String[] attributeProfile) {
        NodeList list = this.getNamedChildren(fieldName, attributeProfile, this.recordFragment, true);
        return this.toFieldArray(list);
    }

    public Field getFirst(String fieldName) {
        return this.getFirst(fieldName, new String[0]);
    }

    public Field getFirst(String fieldName, String attributeName, String attributeValue) {
        String[] attributeProfile = new String[]{attributeName, attributeValue};
        return this.getFirst(fieldName, attributeProfile);
    }

    public Field getFirst(String fieldName, String[] attributeProfile) {
        NodeList list = this.getNamedChildren(fieldName, attributeProfile, this.recordFragment, false);
        if (list.getLength() > 0) {
            return this.toFieldArray(list)[0];
        }
        return new Field(null, null);
    }

    public String getAllFieldData(String delimiter) {
        Object data = "";
        if (this.recordFragment == null) {
            return data;
        }
        NodeList list = this.recordFragment.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() == 3) {
                data = (String)data + list.item(i).getNodeValue();
                continue;
            }
            Field field = new Field(this.getRoot(), list.item(i));
            data = (String)data + delimiter + field.getAllFieldData(delimiter);
        }
        return data;
    }

    private NodeList getNamedChildren(String name, String[] attributeProfile, Node startNode, boolean recursive) {
        NodeSet matchingNodes = new NodeSet();
        if (startNode != null && startNode.getNodeType() != 3) {
            int i;
            NodeList list = startNode.getChildNodes();
            for (i = 0; i < list.getLength(); ++i) {
                Element current;
                if (list.item(i).getNodeType() != 1 || !(current = (Element)list.item(i)).getNodeName().equalsIgnoreCase(name) || !this.checkAttributeValues(current, attributeProfile)) continue;
                matchingNodes.addElement((Node)current);
                if (recursive) continue;
                return matchingNodes;
            }
            for (i = 0; i < list.getLength(); ++i) {
                NodeList matchingChildren = this.getNamedChildren(name, attributeProfile, list.item(i), recursive);
                matchingNodes.addNodes(matchingChildren);
                if (matchingChildren.getLength() <= 0 || recursive) continue;
                return matchingNodes;
            }
        }
        return matchingNodes;
    }

    private boolean checkAttributeValues(Element element, String[] attributeProfile) {
        for (int i = 0; i < attributeProfile.length; i += 2) {
            if (element.getAttribute(attributeProfile[i]).equalsIgnoreCase(attributeProfile[i + 1])) continue;
            return false;
        }
        return true;
    }

    private Field[] toFieldArray(NodeList nodeList) {
        Field[] fieldArray = new Field[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            fieldArray[i] = new Field(this.getRoot(), nodeList.item(i));
        }
        return fieldArray;
    }

    public String getFieldData(String field) {
        return this.getData(this.getList(field));
    }

    public String getFieldData(String field, String attributeName, String attributeValue) {
        NodeList nodeList = this.getList(field);
        Object data = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!((Element)nodeList.item(i)).hasAttribute(attributeName) || !((Element)nodeList.item(i)).getAttribute(attributeName).equalsIgnoreCase(attributeValue)) continue;
            data = (String)data + nodeList.item(i).getFirstChild().getNodeValue();
        }
        return data;
    }

    private String getData(NodeList nodeList) {
        Object fieldData = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).hasChildNodes()) {
                fieldData = (String)fieldData + this.getData(nodeList.item(i).getChildNodes());
                continue;
            }
            if (nodeList.item(i).getNodeType() != 3) continue;
            fieldData = (String)fieldData + nodeList.item(i).getNodeValue() + " ";
        }
        return fieldData;
    }

    public NodeList getList(String field) {
        return ((Element)this.recordFragment).getElementsByTagName(field);
    }
}

