/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.record;

import asn1.ASN1Exception;
import asn1.BEREncoding;
import org.jafer.record.DataObject;
import org.jafer.record.RecordException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import z3950.v3.TermInfo;

public class TermRecord
extends DataObject {
    private Node root;
    private TermInfo termInfo;

    public TermRecord(BEREncoding ber) {
        super("", ber);
    }

    public Node getXML(Document document) throws RecordException {
        Element el;
        this.root = document.createElement("term");
        try {
            this.termInfo = new TermInfo(this.getBER(), true);
        }
        catch (ASN1Exception e) {
            throw new RecordException("ASN1Exception processing record; " + e.toString(), (Throwable)e);
        }
        if (this.termInfo.s_term != null) {
            el = document.createElement("term");
            el.appendChild(document.createTextNode(this.termInfo.s_term.c_general.get()));
            this.root.appendChild(el);
        }
        if (this.termInfo.s_displayTerm != null) {
            el = document.createElement("display");
            el.appendChild(document.createTextNode(this.termInfo.s_displayTerm.value.toString()));
            this.root.appendChild(el);
        }
        if (this.termInfo.s_globalOccurrences != null) {
            el = document.createElement("occurences");
            el.appendChild(document.createTextNode(Integer.toString(this.termInfo.s_globalOccurrences.get())));
            this.root.appendChild(el);
        }
        return this.root;
    }

    public String toString() {
        return "";
    }
}

