/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.test;

import org.jafer.exception.JaferException;
import org.jafer.interfaces.QueryBuilder;
import org.jafer.record.RecordException;
import org.jafer.util.xml.XMLSerializer;
import org.jafer.zclient.ZClient;
import org.jafer.zserver.ZServerManager;
import org.w3c.dom.Node;

public class ServerTest {
    ZClient client = new ZClient();
    Node root = this.client.getDocument().createElement("root");
    QueryBuilder queryBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.client.setHost("127.0.0.1");
            this.client.setDatabases("advance");
            this.client.setPort(211);
            this.client.setRecordSchema("http://www.loc.gov/mods/");
            this.client.setFetchSize(1);
            this.client.setAutoReconnect(0);
            this.client.setCheckRecordFormat(true);
            this.queryBuilder = this.client.newQueryBuilder();
            Node query = this.queryBuilder.getNode("author", "smith");
            int nRes = this.client.submitQuery(query);
            System.out.println("Results = " + nRes);
            for (int i = 1; i <= 10; ++i) {
                try {
                    this.client.setRecordCursor(i);
                    Node xmlRecord = this.client.getCurrentRecord().getXML();
                    this.root.appendChild(xmlRecord);
                    continue;
                }
                catch (RecordException e) {
                    System.out.println("RecordException caught in ServerTest: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (JaferException e) {
            System.out.println("JaferException caught in ServerTest: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Exception caught in ServerTest: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                this.client.close();
                XMLSerializer.out((Node)this.root, (boolean)false, (String)"results.xml");
            }
            catch (Exception e) {
                System.out.println("Exception caught in ServerTest: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] argv) {
        try {
            if (!ZServerManager.isStarted()) {
                ZServerManager.startUp();
            }
            ServerTest serverTest = new ServerTest();
            serverTest.start();
        }
        catch (Exception e) {
            System.out.println("Exception caught in ServerTest MAIN: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

