/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class DOMFactory {
    private static DocumentBuilderFactory factory;
    private static Logger logger;

    private static synchronized DocumentBuilder getDocumentBuilder() {
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String message = "DOMFactory, static initialization: Parser with specified options cannot be built!";
            logger.warn(message, (Throwable)e);
            System.err.print("FATAL: " + message + " Could not initialize DOMFactory.");
            System.exit(-1);
        }
        return builder;
    }

    public static Document newDocument() {
        return DOMFactory.getDocumentBuilder().newDocument();
    }

    public static Document parse(URL resource) throws JaferException {
        try {
            InputStream is = resource.openStream();
            return DOMFactory.parse((InputStream)is);
        }
        catch (Exception e) {
            String message = "DOMFactory, public static Document parse(URL resource): Cannot parse resource; " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
    }

    public static Document parse(File file) throws JaferException {
        Document document = null;
        try {
            DocumentBuilder builder = DOMFactory.getDocumentBuilder();
            document = builder.parse(file);
        }
        catch (IOException e) {
            String message = "DOMFactory, public static Document parse(File file): Cannot parse file " + file + "; " + e.toString();
            logger.warn(message, (Throwable)e);
            throw new JaferException(message, (Throwable)e);
        }
        catch (SAXException e) {
            String message = "DOMFactory:public static Document parse(File file) - Cannot parse file " + file + "; " + e.toString();
            logger.warn(message, (Throwable)e);
            throw new JaferException(message, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String message = "DOMFactory:public static Document parse(File file) - Cannot parse file " + file + "; " + e.toString();
            logger.warn(message, (Throwable)e);
            throw new JaferException(message, (Throwable)e);
        }
        return document;
    }

    public static Document parse(InputStream inStream) throws JaferException {
        Document document = null;
        try {
            DocumentBuilder builder = DOMFactory.getDocumentBuilder();
            document = builder.parse(inStream);
        }
        catch (IOException e) {
            String message = "DOMFactory, public static Document parse(InputStream inStream): Cannot parse stream; " + e.toString();
            logger.warn(message, (Throwable)e);
            throw new JaferException(message, (Throwable)e);
        }
        catch (SAXException e) {
            String message = "DOMFactory, public static Document parse(InputStream inStream): Cannot parse stream; " + e.toString();
            logger.warn(message, (Throwable)e);
            throw new JaferException(message, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String message = "DOMFactory, public static Document parse(InputStream inStream): Cannot parse stream; " + e.toString();
            logger.warn(message, (Throwable)e);
            throw new JaferException(message, (Throwable)e);
        }
        return document;
    }

    public static Document parse(String data) throws JaferException {
        Document document = null;
        try {
            DocumentBuilder builder = DOMFactory.getDocumentBuilder();
            document = builder.parse(new InputSource(new StringReader(data)));
        }
        catch (IOException e) {
            String message = "DOMFactory, public static Document parse(String data): Cannot parse data; " + e.toString();
            logger.warn(message, (Throwable)e);
            throw new JaferException(message, (Throwable)e);
        }
        catch (SAXException e) {
            String message = "DOMFactory, public static Document parse(String data): Cannot parse data; " + e.toString();
            logger.warn(message, (Throwable)e);
            throw new JaferException(message, (Throwable)e);
        }
        return document;
    }

    public static Map getMap(File file) throws JaferException {
        Hashtable<String, String> map = new Hashtable<String, String>();
        NodeList list = null;
        list = DOMFactory.parse((File)file).getDocumentElement().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (Config.getValue((Node)list.item(i)) == null) continue;
            map.put(list.item(i).getNodeName(), Config.getValue((Node)list.item(i)));
        }
        return map;
    }

    public static Map getMap(URL resource) throws JaferException {
        try {
            return DOMFactory.getMap((File)new File(resource.getPath()));
        }
        catch (NullPointerException e) {
            String message = "DOMFactory, public static Map getMap(URL resource): Cannot create Map from resource (" + resource + "); " + e.toString();
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
    }

    public static Node getExceptionNode(Document document, Throwable e) {
        Element exception = document.createElement("exception");
        try {
            exception.setAttribute("oid", Config.getRecordSyntaxFromName((String)"JAFER"));
        }
        catch (JaferException ex) {
            exception.setAttribute("oid", "unknown");
        }
        exception.setAttribute("type", e.getClass().getName());
        Text txt = document.createTextNode(e.toString());
        exception.appendChild(txt);
        if (e.getCause() != null) {
            exception.appendChild(DOMFactory.getExceptionNode((Document)document, (Throwable)e.getCause()));
        }
        return exception;
    }

    public static Node getExceptionNode(Document document, Throwable e, String msg) {
        Node exception = DOMFactory.getExceptionNode((Document)document, (Throwable)e);
        Element message = document.createElement("message");
        Text txt = document.createTextNode(msg);
        message.appendChild(txt);
        exception.appendChild(message);
        return exception;
    }

    public static Node getExceptionNode(Document document, Throwable e, StackTraceElement[] stackTraceElement) {
        Node exception = DOMFactory.getExceptionNode((Document)document, (Throwable)e);
        DOMFactory.appendtStackTrace((Document)document, (Node)exception, (StackTraceElement[])stackTraceElement);
        return exception;
    }

    public static Node getExceptionNode(Document document, Throwable e, StackTraceElement[] stackTraceElement, String msg) {
        Node exception = DOMFactory.getExceptionNode((Document)document, (Throwable)e, (String)msg);
        DOMFactory.appendtStackTrace((Document)document, (Node)exception, (StackTraceElement[])stackTraceElement);
        return exception;
    }

    private static Node appendtStackTrace(Document document, Node exception, StackTraceElement[] stackTraceElement) {
        for (int i = 0; i < stackTraceElement.length; ++i) {
            Element stackTrace = document.createElement("stackTrace");
            Text txt = document.createTextNode(stackTraceElement[i].toString());
            stackTrace.appendChild(txt);
            exception.appendChild(stackTrace);
        }
        return exception;
    }

    static {
        logger = LoggerFactory.getLogger((String)"org.jafer.util");
        factory = DocumentBuilderFactory.newInstance();
    }
}

