/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zclient;

import java.util.Vector;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.interfaces.Authentication;
import org.jafer.interfaces.Cache;
import org.jafer.interfaces.Connection;
import org.jafer.interfaces.Databean;
import org.jafer.interfaces.Logging;
import org.jafer.interfaces.Present;
import org.jafer.interfaces.Queriable;
import org.jafer.interfaces.Scan;
import org.jafer.interfaces.Search;
import org.jafer.interfaces.Z3950Connection;
import org.jafer.query.QueryBuilder;
import org.jafer.query.QueryException;
import org.jafer.record.DataObject;
import org.jafer.record.Field;
import org.jafer.record.RecordException;
import org.jafer.record.RecordFactory;
import org.jafer.record.TermRecord;
import org.jafer.util.ConnectionException;
import org.jafer.util.xml.DOMFactory;
import org.jafer.util.xml.XMLSerializer;
import org.jafer.zclient.ClientSession;
import org.jafer.zclient.operations.PresentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ZClient
extends Databean
implements Cache,
Logging,
Connection,
Z3950Connection,
Authentication,
Queriable,
Search,
Present,
Scan {
    public static final String DEFAULT_DATABASE_NAME = "xxdefault";
    public static final String DEFAULT_RESULTSET_NAME = "default";
    public static final String DEFAULT_SEARCH_PROFILE = "0.0.0.0.0.0";
    public static final String DEFAULT_ELEMENT_SPEC = "F";
    public static final int DEFAULT_FETCH_SIZE = 10;
    public static final double DEFAULT_FETCH_VIEW = 1.0;
    public static final int DEFAULT_DATACACHE_SIZE = 512;
    public static final int MAX_DATACACHE_SIZE = 2048;
    public static final int TIMEOUT = 600000;
    public static final int AUTO_RECONNECT = 5;
    public static final String DEFAULT_RECORD_SCHEMA = "http://www.loc.gov/mods/";
    private int fetchSize;
    private int dataCacheSize;
    private int autoReconnect;
    private int timeout;
    private int attempts;
    private int numberOfRequestRecords;
    private int startRecordNumber;
    private int nResults;
    private int port;
    private double fetchView;
    private final boolean debug = false;
    private boolean checkRecordFormat = false;
    private boolean parseQuery = true;
    private Integer recordCursor;
    private String elementSpec;
    private String userIP;
    private String remoteAddress;
    private String resultSetName;
    private String recordSchema;
    private String recordSyntax;
    private String searchProfile;
    private String host;
    private String username;
    private String password;
    private String group;
    private String[] dataBases;
    private ClientSession clientSession;
    private org.jafer.record.Cache cache;
    private RecordFactory recordFactory;
    private QueryBuilder queryBuilder;
    private Document document;
    private Document queryDocument;
    private static Logger logger;

    public ZClient() {
        logger = LoggerFactory.getLogger((String)"org.jafer.zclient");
        logger.debug("initializing ZClient...");
        this.setDefaults();
    }

    private void setDefaults() {
        logger.debug("ZClient", (Object)"private void setDefaults()");
        this.userIP = this.getRemoteAddress() == null ? "" : "<" + this.getRemoteAddress() + ">";
        if (this.getDocument() == null) {
            this.setDocument(DOMFactory.newDocument());
        }
        if (this.getRecordFactory() == null) {
            this.setRecordFactory(new RecordFactory("TODO"));
        }
        if (this.getDatabases() == null) {
            this.setDatabases(DEFAULT_DATABASE_NAME);
        } else {
            for (int i = 0; i < this.getDatabases().length; ++i) {
                if (this.getDatabases()[i] != null) continue;
                this.setDatabases(DEFAULT_DATABASE_NAME);
            }
        }
        if (this.getDataCacheSize() < 1 || this.getDataCacheSize() > 2048) {
            this.setDataCacheSize(512);
        }
        if (this.getFetchSize() < 1 || this.getFetchSize() > this.getDataCacheSize()) {
            this.setFetchSize(this.getDataCacheSize() < 10 ? this.getDataCacheSize() : 10);
        }
        if (this.getFetchView() < 0.0 || this.getFetchView() > 1.0) {
            this.setFetchView(1.0);
        }
        if (this.getResultSetName() == null) {
            this.setResultSetName(DEFAULT_RESULTSET_NAME);
        }
        if (this.getElementSpec() == null) {
            this.setElementSpec(DEFAULT_ELEMENT_SPEC);
        }
        if (this.getAutoReconnect() < 0) {
            this.setAutoReconnect(5);
        }
        if (this.getTimeout() < 0) {
            this.setTimeout(600000);
        }
        if (this.getSearchProfile() == null) {
            this.setSearchProfile(DEFAULT_SEARCH_PROFILE);
        }
        if (this.getRecordSchema() == null) {
            this.setRecordSchema(DEFAULT_RECORD_SCHEMA);
        }
        logger.debug("Java version: " + System.getProperty("java.version"));
        logger.debug("Java home: " + System.getProperty("java.home"));
        logger.debug("Classpath: " + System.getProperty("java.class.path"));
        logger.debug("Operating system: " + System.getProperty("os.name"));
        logger.debug("ZClient property dataCacheSize: " + this.getDataCacheSize());
        logger.debug("ZClient property fetchSize: " + this.getFetchSize());
        logger.debug("ZClient property fetchView: " + this.getFetchView());
        logger.debug("ZClient property elementSpec: " + this.getElementSpec());
        logger.debug("ZClient property recordSchema: " + this.getRecordSchema());
        logger.debug("ZClient property host: " + this.getHost());
        logger.debug("ZClient property port: " + this.getPort());
        logger.debug("ZClient property dataBases: " + this.getDatabaseNames());
        logger.debug("ZClient", (Object)"private void setDefaults()");
    }

    public int submitQuery(Node query) throws JaferException {
        try {
            this.setDefaults();
            if (this.isParseQuery()) {
                if (this.getQueryBuilder() == null) {
                    this.setQueryBuilder(new QueryBuilder(this.getSearchProfile()));
                }
                query = this.getQueryBuilder().parse(query);
            }
            this.setQuery(query);
            this.setCache(new org.jafer.record.Cache(this.getRecordFactory(), this.getDataCacheSize()));
            this.connect();
            return this.search();
        }
        catch (QueryException e) {
            String message = this.userIP + "ZClient submitQuery(Node query); " + e.getMessage();
            logger.warn(message);
            throw new JaferException((Throwable)e);
        }
    }

    private void connect() throws JaferException {
        if (this.getSession() == null || this.getSession().getGroup() != this.getGroup() || this.getSession().getUsername() != this.getUsername() || this.getSession().getPassword() != this.getPassword()) {
            try {
                this.setSession(new ClientSession(this.getHost(), this.getPort(), this.getTimeout()));
                this.getSession().init(this.getGroup(), this.getUsername(), this.getPassword());
            }
            catch (ConnectionException e) {
                if (this.allowReconnect()) {
                    String message = this.userIP + "ZClient Connection error - connecting again (host: " + this.getHost() + ", port: " + this.getPort() + ", username: " + this.getUsername() + ", group: " + this.getGroup() + ")";
                    logger.warn(message);
                    this.reConnect();
                }
                String message = this.userIP + "Connection failure - host: " + this.getHost() + ", port: " + this.getPort() + ", username: " + this.getUsername() + ", group: " + this.getGroup() + " (" + e.getMessage() + ")";
                logger.warn(message);
                throw new JaferException(message, (Throwable)e);
            }
        }
    }

    private void reConnect() throws JaferException {
        this.setAttempts(this.getAttempts() + 1);
        String message = "Re-starting clientSession... (autoReconnect " + this.getAttempts() + ")";
        logger.info(this.userIP + message);
        this.close();
        this.connect();
    }

    private int search() throws JaferException {
        logger.debug("ZClient", (Object)"private int search()");
        logger.debug(this.userIP + "Submitting query...");
        try {
            this.setNumberOfResults(this.getSession().search(this.getQuery(), this.getDatabases(), this.getResultSetName()));
            this.setNumberOfRequestRecords(this.getFetchSize());
            logger.debug(this.userIP + "Number of search results: " + this.getNumberOfResults());
            logger.debug("ZClient", (Object)"int search()");
            return this.getNumberOfResults();
        }
        catch (ConnectionException e) {
            if (this.allowReconnect()) {
                String message = this.userIP + "Connection failure whilst submitting query - connecting again";
                logger.warn(message);
                this.reConnect();
                return this.setNumberOfResults(this.search());
            }
            String message = this.userIP + "Connection failure whilst submitting query (autoReconnect = " + this.getAutoReconnect() + ")";
            logger.warn(message);
            throw new JaferException(message, (Throwable)e);
        }
        catch (JaferException e) {
            String message = this.userIP + "Error attempting search (host " + this.getHost() + ", port " + this.getPort() + ", dataBase(s) " + this.getDatabaseNames() + ", username " + this.getUsername() + "): ";
            if (this.getQueryBuilder() != null && this.getQueryBuilder().isDummyNodePresent() && e.getDiagnostic() != null && e.getDiagnostic().getCondition() == 117 && e.getDiagnostic().getAddInfo().equalsIgnoreCase("103")) {
                message = message + "Query structure not supported by server, try restructuring query - diagnostic: ";
            }
            message = message + e.getMessage();
            logger.warn(message);
            throw new JaferException(message);
        }
    }

    public void setRecordCursor(int nRecord) throws JaferException {
        logger.debug("ZClient", (Object)"public void setRecordCursor(int nRecord)");
        if (nRecord > 0 && nRecord <= this.getNumberOfResults()) {
            this.recordCursor = new Integer(nRecord);
            if (!this.getCache().contains(this.recordCursor)) {
                try {
                    this.setStartRecordNumber(nRecord);
                    Vector dataObjects = this.getSession().present(this.getStartRecordNumber(), this.getNumberOfRequestRecords(), Config.convertSyntax((String)Config.getRecordSyntax((String)this.getRecordSchema())), this.getElementSpec(), this.getResultSetName());
                    for (int n = 0; n < dataObjects.size(); ++n) {
                        this.getCache().put(new Integer(this.getStartRecordNumber() + n), (DataObject)dataObjects.get(n));
                    }
                }
                catch (PresentException e) {
                    int status = e.getStatus();
                    switch (status) {
                        case 1: {
                            this.handleError(this.userIP + "Present status = " + status + ": " + e.getMessage() + " (record " + this.getStartRecordNumber() + "): records requested = " + this.getNumberOfRequestRecords() + ", records returned = " + e.getNumberOfRecordsReturned());
                            if (this.allowReconnect()) {
                                this.reConnect();
                                this.search();
                                this.setRecordCursor(this.getRecordCursor());
                                break;
                            }
                            this.handleError(this.userIP + "Persistent failure whilst retrieving records (autoReconnect = " + this.getAutoReconnect() + ")", (JaferException)((Object)e));
                            break;
                        }
                        case 2: {
                            if (e.getNumberOfRecordsReturned() > 1) {
                                this.handleError(this.userIP + "Present status = " + status + ": " + e.getMessage() + " (record " + this.getStartRecordNumber() + "): decreasing Fetch size from " + this.getNumberOfRequestRecords() + " to " + e.getNumberOfRecordsReturned());
                                this.setNumberOfRequestRecords(e.getNumberOfRecordsReturned());
                                this.setRecordCursor(this.getRecordCursor());
                                break;
                            }
                            this.handleError(this.userIP + "Present status = " + status + "; requested record was not returned - message size is too small (record " + this.getStartRecordNumber() + "): records requested = " + this.getNumberOfRequestRecords() + ", records returned = " + e.getNumberOfRecordsReturned(), (JaferException)((Object)e));
                            break;
                        }
                        case 3: {
                            this.handleError(this.userIP + "Present status = " + status + "; requested record was not returned - message size is too small (record " + this.getStartRecordNumber() + "): records requested = " + this.getNumberOfRequestRecords() + ", records returned = " + e.getNumberOfRecordsReturned());
                            if (this.allowReconnect()) {
                                this.reConnect();
                                this.search();
                                this.setRecordCursor(this.getRecordCursor());
                                break;
                            }
                            this.handleError(this.userIP + "Persistent failure whilst retrieving records (autoReconnect = " + this.getAutoReconnect() + ")", (JaferException)((Object)e));
                            break;
                        }
                        case 4: {
                            this.handleError(this.userIP + "Present status = " + status + ": " + e.getMessage() + " (record " + this.getStartRecordNumber() + "): records requested = " + this.getNumberOfRequestRecords() + ", records returned = " + e.getNumberOfRecordsReturned());
                            if (this.allowReconnect()) {
                                this.reConnect();
                                this.search();
                                this.setRecordCursor(this.getRecordCursor());
                                break;
                            }
                            this.handleError(this.userIP + "Persistent failure whilst retrieving records (autoReconnect = " + this.getAutoReconnect() + ")", (JaferException)((Object)e));
                            break;
                        }
                        case 5: {
                            this.handleError(this.userIP + "Present failed status = " + status + ": " + e.getMessage() + " (record " + this.getStartRecordNumber() + ")", (JaferException)((Object)e));
                        }
                    }
                }
                catch (ConnectionException e) {
                    if (this.allowReconnect()) {
                        this.handleError(this.userIP + "Connection failure whilst retrieving records (record " + this.getStartRecordNumber() + ") - connecting again (" + e.toString() + ")");
                        this.reConnect();
                        this.search();
                        this.setRecordCursor(this.getRecordCursor());
                    }
                    this.handleError(this.userIP + "Connection failure whilst retrieving records (autoReconnect = " + this.getAutoReconnect() + ")", (JaferException)((Object)e));
                }
            }
        } else {
            String message = this.userIP + "Record number " + nRecord + " not found (number of search results = " + this.getNumberOfResults() + ")";
            this.handleError(message, new JaferException(message));
        }
        logger.debug("ZClient", (Object)"public void setRecordCursor(int nRecord)");
    }

    private void handleError(String message) {
        logger.warn(message);
    }

    private void handleError(String message, JaferException e) throws JaferException {
        logger.warn(message);
        throw e;
    }

    public int getRecordCursor() {
        return this.recordCursor;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    private String getDatabaseNames() {
        Object dbNames = "";
        for (int i = 0; i < this.getDatabases().length; ++i) {
            dbNames = (String)dbNames + this.getDatabases()[i] + " ";
        }
        return dbNames;
    }

    protected void finalize() throws JaferException {
        this.close();
        this.setSession(null);
        this.setCache(null);
        this.setRecordFactory(null);
        this.setQueryBuilder(null);
        this.setDocument(null);
        this.setQueryDocument(null);
    }

    public void close() throws JaferException {
        if (this.getSession() != null) {
            this.getSession().close();
            this.setSession(null);
        }
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setParseQuery(boolean parseQuery) {
        this.parseQuery = parseQuery;
    }

    public boolean isParseQuery() {
        return this.parseQuery;
    }

    public void setRecordSchema(String recordSchema) {
        this.recordSchema = recordSchema;
    }

    public String getRecordSchema() {
        return this.recordSchema;
    }

    private void setRecordFactory(RecordFactory recordFactory) {
        this.recordFactory = recordFactory;
    }

    private RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    private void setSession(ClientSession clientSession) {
        this.clientSession = clientSession;
    }

    private ClientSession getSession() {
        return this.clientSession;
    }

    private void setCache(org.jafer.record.Cache cache) {
        this.cache = cache;
    }

    private org.jafer.record.Cache getCache() {
        return this.cache;
    }

    private void setQueryDocument(Document queryDocument) {
        this.queryDocument = queryDocument;
    }

    private Document getQueryDocument() {
        return this.queryDocument;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAutoReconnect(int autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public int getAutoReconnect() {
        return this.autoReconnect;
    }

    private void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    private int getAttempts() {
        return this.attempts;
    }

    private boolean allowReconnect() {
        return this.getAttempts() < this.getAutoReconnect();
    }

    private void setNumberOfRequestRecords(int numberOfRequestRecords) {
        this.numberOfRequestRecords = numberOfRequestRecords < 1 || numberOfRequestRecords > this.getNumberOfResults() ? 1 : numberOfRequestRecords;
    }

    private int getNumberOfRequestRecords() {
        return this.numberOfRequestRecords;
    }

    private void setStartRecordNumber(int nRecord) {
        int backwardOffset;
        logger.debug("ZClient", (Object)"private void setStartRecordNumber(int nRecord)");
        int forwardOffset = (int)((double)(this.getNumberOfRequestRecords() - 1) * this.getFetchView());
        if (nRecord + forwardOffset > this.getNumberOfResults()) {
            forwardOffset = this.getNumberOfResults() - nRecord;
            backwardOffset = this.getNumberOfRequestRecords() - 1 - forwardOffset;
        } else {
            backwardOffset = this.getNumberOfRequestRecords() - 1 - forwardOffset;
            if (nRecord - backwardOffset < 1) {
                backwardOffset = nRecord - 1;
                forwardOffset = this.getNumberOfRequestRecords() - 1 - backwardOffset;
            }
        }
        logger.debug("ZClient", (Object)"private void setStartRecordNumber(int nRecord)");
        this.startRecordNumber = nRecord - backwardOffset;
    }

    private int getStartRecordNumber() {
        return this.startRecordNumber;
    }

    public Field getCurrentRecord() throws JaferException {
        String schema;
        Node recordRoot = this.cache.getXML(this.getDocument(), this.getRecordSchema(), this.getRecordCursorAsInteger());
        int[] syntax = Config.convertSyntax((String)((Element)recordRoot).getAttribute("syntax"));
        if (Config.isSyntaxEqual((int[])syntax, (int[])Config.convertSyntax((String)Config.getRecordSyntaxFromName((String)"DIAG_BIB1")))) {
            throw new RecordException("Returned record is Surrogate Diagnostic", new Field(recordRoot, recordRoot.getFirstChild()));
        }
        if (Config.isSyntaxEqual((int[])syntax, (int[])Config.convertSyntax((String)Config.getRecordSyntaxFromName((String)"JAFER")))) {
            throw new RecordException("Error generating XML from returned record", new Field(recordRoot, recordRoot.getFirstChild()));
        }
        if (this.isCheckRecordFormat() && !(schema = ((Element)recordRoot).getAttribute("schema")).equals(this.getRecordSchema())) {
            throw new RecordException("Returned record (schema: " + schema + ") does not match requested schema " + this.getRecordSchema(), new Field(recordRoot, recordRoot.getFirstChild()));
        }
        return new Field(recordRoot, recordRoot.getFirstChild());
    }

    public DataObject getCurrentDataObject() throws JaferException {
        return this.cache.getDataObject(this.getRecordCursorAsInteger());
    }

    public String getCurrentDatabase() throws JaferException {
        return this.cache.getDataObject(this.getRecordCursorAsInteger()).getDatabaseName();
    }

    public String getCurrentRecordSyntax() throws JaferException {
        return Config.convertSyntax((int[])this.cache.getDataObject(this.getRecordCursorAsInteger()).getRecordSyntax());
    }

    public String getCurrentRecordSyntaxName() throws JaferException {
        return Config.getRecordNameFromSyntax((String)this.getCurrentRecordSyntax());
    }

    public void setHost(String host) {
        if (!host.equalsIgnoreCase(this.host)) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.host = host;
        }
    }

    public void setPort(int port) {
        if (this.port != port) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.port = port;
        }
    }

    public void setResultSetName(String resultSetName) {
        this.resultSetName = resultSetName;
    }

    public void setDatabases(String[] databases) {
        this.dataBases = databases;
    }

    public void setDatabases(String database) {
        this.setDatabases(new String[]{database});
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSearchProfile(String searchProfile) {
        this.searchProfile = searchProfile;
    }

    public void setCheckRecordFormat(boolean checkRecordFormat) {
        this.checkRecordFormat = checkRecordFormat;
    }

    public boolean isCheckRecordFormat() {
        return this.checkRecordFormat;
    }

    public void setElementSpec(String elementSpec) {
        this.elementSpec = elementSpec;
    }

    public void setDataCacheSize(int dataCacheSize) {
        this.dataCacheSize = dataCacheSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setFetchView(double fetchView) {
        this.fetchView = fetchView;
    }

    private int setNumberOfResults(int nResults) {
        this.nResults = nResults;
        return this.nResults;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getResultSetName() {
        return this.resultSetName;
    }

    public String[] getDatabases() {
        return this.dataBases;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getSearchProfile() {
        return this.searchProfile;
    }

    public String getElementSpec() {
        return this.elementSpec;
    }

    public Node getQuery() {
        if (this.getQueryDocument() != null && this.getQueryDocument().getFirstChild() != null) {
            return this.getQueryDocument().getFirstChild();
        }
        return null;
    }

    public int getDataCacheSize() {
        return this.dataCacheSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public double getFetchView() {
        return this.fetchView;
    }

    public int getNumberOfResults() {
        return this.nResults;
    }

    private Integer getRecordCursorAsInteger() {
        return this.recordCursor;
    }

    public org.jafer.interfaces.QueryBuilder newQueryBuilder() {
        return this.setQueryBuilder(new QueryBuilder(this.getSearchProfile()));
    }

    private QueryBuilder setQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        return queryBuilder;
    }

    private QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public void saveQuery(String file) throws JaferException {
        logger.debug("ZClient", (Object)"public void saveQuery(String file)");
        try {
            XMLSerializer.out((Node)this.getQuery(), (boolean)false, (String)file);
        }
        catch (JaferException e) {
            String message = this.userIP + "ZClient, public void saveQuery(String file): cannot save query to file " + file + "; " + e.toString();
            logger.warn(message, (Throwable)e);
            throw e;
        }
        logger.debug("ZClient", (Object)"public void saveQuery(String file)");
    }

    public Field[] getTerms(int noOfTerms, Node term) {
        return this.getTerms(noOfTerms, 1, 1, term);
    }

    public Field[] getTerms(int noOfTerms, int termStep, int termPosition, Node term) {
        try {
            Vector rawTerms = this.clientSession.scan(this.getDatabases(), noOfTerms, termStep, termPosition, term);
            Field[] terms = new Field[rawTerms.size()];
            for (int n = 0; n < rawTerms.size(); ++n) {
                TermRecord termRecord = (TermRecord)rawTerms.get(n);
                terms[n] = new Field(termRecord.getXML(this.getDocument()), termRecord.getXML(this.getDocument()));
            }
            return terms;
        }
        catch (Exception e) {
            return new Field[0];
        }
    }

    private void setQuery(Node query) {
        this.setQueryDocument(query.getOwnerDocument());
        if (this.getQueryDocument().hasChildNodes()) {
            this.getQueryDocument().removeChild(this.getQuery());
        }
        this.getQueryDocument().appendChild(query);
    }
}

