/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zclient.operations;

import asn1.ASN1GeneralString;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import java.util.Vector;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.query.XMLRPNQuery;
import org.jafer.record.TermRecord;
import org.jafer.util.ConnectionException;
import org.jafer.util.PDUDriver;
import org.jafer.zclient.ClientSession;
import org.w3c.dom.Node;
import z3950.v3.AttributeSetId;
import z3950.v3.AttributesPlusTerm;
import z3950.v3.DatabaseName;
import z3950.v3.InternationalString;
import z3950.v3.PDU;
import z3950.v3.ScanRequest;
import z3950.v3.ScanResponse;

public class Scan {
    private ClientSession clientSession;
    private PDUDriver pduDriver;

    public Scan(ClientSession clientSession) {
        this.clientSession = clientSession;
        this.pduDriver = clientSession.getPDUDriver();
    }

    public Vector scan(String[] databases, int nTerms, int step, int position, Node term) throws JaferException, ConnectionException {
        XMLRPNQuery xmlQuery = new XMLRPNQuery();
        return this.scan(databases, nTerms, step, position, (Object)xmlQuery.processConstraintModel((Node)term).c_op.c_attrTerm);
    }

    public Vector scan(String[] databases, int nTerms, int step, int position, Object termObject) throws JaferException, ConnectionException {
        if (!(termObject instanceof AttributesPlusTerm)) {
            throw new JaferException("termObject is not of type z3950.v3.AttributesPlusTerm");
        }
        AttributesPlusTerm term = (AttributesPlusTerm)termObject;
        Vector<TermRecord> terms = new Vector<TermRecord>();
        ScanRequest sr = new ScanRequest();
        sr.s_attributeSet = new AttributeSetId();
        sr.s_attributeSet.value = new ASN1ObjectIdentifier(Config.convertSyntax((String)Config.getAttributeSetSyntax()));
        DatabaseName[] databaseNames = new DatabaseName[databases.length];
        for (int n = 0; n < databases.length; ++n) {
            databaseNames[n] = new DatabaseName();
            databaseNames[n].value = new InternationalString();
            databaseNames[n].value.value = new ASN1GeneralString(databases[n]);
        }
        sr.s_databaseNames = databaseNames;
        sr.s_numberOfTermsRequested = new ASN1Integer(nTerms);
        sr.s_stepSize = new ASN1Integer(step);
        sr.s_preferredPositionInResponse = new ASN1Integer(position);
        sr.s_termListAndStartPoint = term;
        PDU pduResponse = new PDU();
        pduResponse.c_scanRequest = sr;
        this.pduDriver.sendPDU(pduResponse);
        PDU pduRequest = this.pduDriver.getPDU();
        ScanResponse response = pduRequest.c_scanResponse;
        if (response.s_scanStatus.get() == 0) {
            for (int n = 0; n < response.s_entries.s_entries.length; ++n) {
                try {
                    terms.add(new TermRecord(response.s_entries.s_entries[n].c_termInfo.ber_encode()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return terms;
    }
}

