/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zclient.operations;

import asn1.ASN1Boolean;
import asn1.ASN1GeneralString;
import asn1.ASN1Integer;
import asn1.ASN1OctetString;
import org.jafer.exception.JaferException;
import org.jafer.query.XMLRPNQuery;
import org.jafer.record.Diagnostic;
import org.jafer.util.ConnectionException;
import org.jafer.util.PDUDriver;
import org.jafer.zclient.ClientSession;
import org.w3c.dom.Node;
import z3950.v3.DatabaseName;
import z3950.v3.InternationalString;
import z3950.v3.PDU;
import z3950.v3.Query;
import z3950.v3.RPNQuery;
import z3950.v3.ReferenceId;
import z3950.v3.SearchRequest;
import z3950.v3.SearchResponse;

public class Search {
    private final ClientSession clientSession;
    private final PDUDriver pduDriver;
    private static int refId = 0;

    public Search(ClientSession clientSession) {
        this.clientSession = clientSession;
        this.pduDriver = clientSession.getPDUDriver();
    }

    public int search(Node domQuery, String[] databases, String resultSetName) throws JaferException, ConnectionException {
        XMLRPNQuery xmlRPNQuery = new XMLRPNQuery();
        return this.search((Object)xmlRPNQuery.getRPNQuery(domQuery), databases, resultSetName);
    }

    public int search(Object rpnQueryObject, String[] databases, String resultSetName) throws JaferException, ConnectionException {
        if (!(rpnQueryObject instanceof RPNQuery)) {
            throw new JaferException("rpnQueryObject is not of type z3950.v3.RPNQuery");
        }
        RPNQuery rpnQuery = (RPNQuery)rpnQueryObject;
        SearchRequest search = new SearchRequest();
        try {
            search.s_query = new Query();
            search.s_query.c_type_1 = rpnQuery;
            search.s_smallSetUpperBound = new ASN1Integer(0);
            search.s_largeSetLowerBound = new ASN1Integer(1);
            search.s_mediumSetPresentNumber = new ASN1Integer(0);
            search.s_replaceIndicator = new ASN1Boolean(true);
            search.s_resultSetName = new InternationalString();
            search.s_resultSetName.value = new ASN1GeneralString(resultSetName);
            search.s_referenceId = new ReferenceId();
            search.s_referenceId.value = new ASN1OctetString("org.jafer.zclient.search_" + ++refId);
            DatabaseName[] dbs = new DatabaseName[databases.length];
            for (int n = 0; n < databases.length; ++n) {
                dbs[n] = new DatabaseName();
                dbs[n].value = new InternationalString();
                dbs[n].value.value = new ASN1GeneralString(databases[n]);
            }
            search.s_databaseNames = dbs;
        }
        catch (NullPointerException e) {
            String message = "Search: NullPointer Error(" + e.toString() + ")";
            throw new JaferException(message, (Throwable)e);
        }
        PDU pduResponse = new PDU();
        pduResponse.c_searchRequest = search;
        this.pduDriver.sendPDU(pduResponse);
        PDU pduRequest = this.pduDriver.getPDU();
        SearchResponse response = pduRequest.c_searchResponse;
        if (response.s_searchStatus != null && !response.s_searchStatus.get()) {
            Object message = "";
            Diagnostic diagnostic = null;
            if (response.s_records.c_nonSurrogateDiagnostic != null) {
                try {
                    diagnostic = new Diagnostic(databases[0], response.s_records.c_nonSurrogateDiagnostic.ber_encode());
                    message = diagnostic.toString();
                }
                catch (Exception e) {
                    message = "diagnostic not available - ASN1Exception processing diagnostic (" + e.toString() + ")";
                }
            }
            throw new JaferException((String)message, diagnostic);
        }
        return response.s_resultCount.get();
    }
}

