/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.util.xml.DOMFactory;
import org.jafer.util.xml.XMLSerializer;
import org.jafer.util.xml.XMLTransformer;
import org.jafer.zserver.Session;
import org.jafer.zserver.ZServer;
import org.jafer.zserver.ZServerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZServerManager {
    public static final long STOP_TIMEOUT = 10000L;
    public static final long KILL_TIMEOUT = 1L;
    public static final int SESSION_TIMEOUT = 900000;
    private ZServer[] servers = null;
    private static Logger logger;
    private static ZServerManager zServerManager;

    public ZServerManager() {
        logger = LoggerFactory.getLogger((String)"org.jafer.zserver");
    }

    public void startServer() {
        if (this.servers == null) {
            logger.warn("ZServerManager not started");
        } else {
            for (int i = 0; i < this.servers.length; ++i) {
                if (this.servers[i].isStopped()) {
                    this.servers[i].start();
                    continue;
                }
                logger.info(this.servers[i].getName() + " is already running");
            }
        }
    }

    public void startServer(int n) {
        if (this.servers == null) {
            logger.warn("ZServerManager not started");
        } else {
            for (int i = 0; i < this.servers.length; ++i) {
                if (this.servers[i].getId() != (long)n) continue;
                if (this.servers[i].isStopped()) {
                    this.servers[i].start();
                    break;
                }
                logger.info(this.servers[i].getName() + " is already running");
                break;
            }
        }
    }

    public void stopServer(long timeout) {
        if (this.servers == null) {
            logger.warn("ZServerManager not started");
        } else {
            for (int i = 0; i < this.servers.length; ++i) {
                if (this.servers[i].isStopped()) {
                    logger.info(this.servers[i].getName() + " has stopped");
                    continue;
                }
                this.servers[i].halt(timeout);
            }
        }
    }

    public void stopServer(long timeout, int n) {
        if (this.servers == null) {
            logger.warn("ZServerManager not started");
        } else {
            for (int i = 0; i < this.servers.length; ++i) {
                if (this.servers[i].getId() != (long)n) continue;
                if (this.servers[i].isStopped()) {
                    logger.info(this.servers[i].getName() + " has stopped");
                    break;
                }
                this.servers[i].halt(timeout);
                break;
            }
        }
    }

    public void reStartServer(long timeout) {
        this.stopServer(timeout);
        this.startServer();
    }

    public void stopSession(long timeout) {
        if (this.servers == null) {
            logger.warn("ZServerManager not started");
        } else {
            for (int i = 0; i < this.servers.length; ++i) {
                if (!this.servers[i].hasThreads()) continue;
                Vector sessions = this.servers[i].purgeThreads();
                for (int j = 0; j < sessions.size(); ++j) {
                    ((ZServerThread)sessions.get(j)).halt(timeout);
                }
            }
        }
    }

    public void stopSession(long timeout, int n) {
        if (this.servers == null) {
            logger.warn("ZServerManager not started");
        } else {
            for (int i = 0; i < this.servers.length; ++i) {
                if (!this.servers[i].hasThreads()) continue;
                Vector sessions = this.servers[i].purgeThreads();
                for (int j = 0; j < sessions.size(); ++j) {
                    if (((ZServerThread)sessions.get(j)).getId() != (long)n) continue;
                    ((ZServerThread)sessions.get(j)).halt(timeout);
                }
            }
        }
    }

    public void stopSession() {
        this.stopSession(10000L);
    }

    public void stopSession(int n) {
        this.stopSession(10000L, n);
    }

    public void killSession() {
        this.stopSession(1L);
    }

    public void killSession(int n) {
        this.stopSession(1L, n);
    }

    public static void shutDown() {
        ZServerManager.shutDown((long)10000L);
    }

    public Node getInfo(Document document) {
        Node serverNode = null;
        Node sessionNode = null;
        Element root = document.createElement("root");
        if (this.servers == null) {
            logger.warn("ZServerManager not started");
        } else {
            for (int i = 0; i < this.servers.length; ++i) {
                serverNode = root.appendChild(this.getInfo((ZServerThread)this.servers[i], document));
                this.appendSocketInfo(this.servers[i], document, serverNode);
                if (!this.servers[i].hasThreads()) continue;
                Vector sessions = this.servers[i].purgeThreads();
                for (int j = 0; j < sessions.size(); ++j) {
                    if (((ZServerThread)sessions.get(j)).isStopped()) continue;
                    sessionNode = serverNode.appendChild(this.getInfo((ZServerThread)sessions.get(j), document));
                    this.appendSocketInfo(this.servers[i], document, sessionNode);
                }
            }
        }
        return root;
    }

    public void setLoggerLevel(Level level) {
    }

    private Node getInfo(ZServerThread zServerThread, Document document) {
        Element root = document.createElement("thread");
        root.setAttribute("id", String.valueOf(zServerThread.getId()));
        Node upTime = root.appendChild(document.createElement("upTime"));
        upTime.appendChild(document.createTextNode(String.valueOf(zServerThread.getUpTime())));
        Node state = root.appendChild(document.createElement("state"));
        state.appendChild(document.createTextNode(String.valueOf((Object)zServerThread.getState())));
        Node threads = root.appendChild(document.createElement("threads"));
        threads.appendChild(document.createTextNode(String.valueOf(zServerThread.getNumberOfActiveThreads())));
        return root;
    }

    private void appendSocketInfo(ZServer zServer, Document document, Node serverNode) {
        Node port = serverNode.appendChild(document.createElement("port"));
        port.appendChild(document.createTextNode(String.valueOf(zServer.getBindingPort())));
        Node address = serverNode.appendChild(document.createElement("address"));
        address.appendChild(document.createTextNode(zServer.getBindingAddress()));
    }

    private void appendSocketInfo(Session session, Document document, Node sessionNode) {
        Node port = sessionNode.appendChild(document.createElement("port"));
        port.appendChild(document.createTextNode(String.valueOf(session.getPort())));
        Node address = sessionNode.appendChild(document.createElement("address"));
        address.appendChild(document.createTextNode(session.getClientAddress()));
    }

    public void save(String path) throws JaferException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLEncoder toXml = new XMLEncoder(out);
        toXml.writeObject(this);
        toXml.flush();
        toXml.close();
        Document xml = DOMFactory.parse((InputStream)new ByteArrayInputStream(out.toByteArray()));
        XMLSerializer.out((Node)XMLTransformer.transform((Node)xml.getFirstChild(), (InputStream)Config.getServerDecode()), (String)"xml", (String)path);
    }

    private void loadManager(Document document) throws JaferException {
        Element xmlIn = document.getDocumentElement();
        Node xml = XMLTransformer.transform((Node)xmlIn, (InputStream)Config.getServerDecode());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLSerializer.out((Node)xml, (String)"xml", (OutputStream)out);
        XMLDecoder fromXml = new XMLDecoder(new ByteArrayInputStream(out.toByteArray()));
        this.servers = (ZServer[])fromXml.readObject();
    }

    public static ZServerManager startUp() {
        try {
            ZServerManager.setManager((ZServerManager)new ZServerManager());
            zServerManager.loadManager(Config.getServerConfigDocument());
            zServerManager.startServer();
            return zServerManager;
        }
        catch (JaferException ex) {
            String message = "Cannot load ZServerManager: " + ex.toString();
            logger.warn(message, (Throwable)ex);
            System.err.print("FATAL: " + message);
            ex.printStackTrace(System.err);
            System.exit(-1);
            return null;
        }
    }

    public static void shutDown(long timeout) {
        if (zServerManager != null) {
            ZServerManager.getManager().stopServer(timeout);
            ZServerManager.setManager(null);
        }
    }

    public static boolean isStarted() {
        return zServerManager != null;
    }

    public static ZServerManager getManager() {
        if (zServerManager == null) {
            logger.warn("ZServerManager not started; use ZServerManager startUp()");
        }
        return zServerManager;
    }

    private static void setManager(ZServerManager mgr) {
        zServerManager = mgr;
    }
}

