/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZServerThread
extends Thread
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ZServerThread.class);
    public static int STATE_RUNNING = 0;
    public static int STATE_STOPPED = 1;
    public static int STATE_STOPPING = 2;
    private volatile boolean stopping = true;
    private volatile boolean stopped = true;
    private Vector threads;
    private int state;
    private long startTime;

    public ZServerThread(String name) {
        this.setThreadName(name);
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setThreads(Vector threads) {
        this.threads = threads;
    }

    public Vector getThreads() {
        return this.threads;
    }

    public boolean hasThreads() {
        return this.threads != null;
    }

    public Vector purgeThreads() {
        if (this.threads == null) {
            return null;
        }
        Enumeration en = this.threads.elements();
        while (en.hasMoreElements()) {
            Thread thread = (Thread)en.nextElement();
            if (thread.isAlive()) continue;
            this.threads.remove(thread);
        }
        return this.threads;
    }

    public void startThread(Thread thread) {
        thread.start();
        this.threads.add(thread);
    }

    public void setThreadName(String name) {
        this.setName(name + this.getName().substring(this.getName().indexOf(45)));
    }

    @Override
    public long getId() {
        return Integer.parseInt(this.getName().substring(this.getName().indexOf(45) + 1));
    }

    public void halt(long timeout) {
        logger.debug(this.getName() + " halt...");
        this.setStopping(true);
        if (this.hasThreads()) {
            Enumeration en = this.purgeThreads().elements();
            while (en.hasMoreElements()) {
                ZServerThread zThread = (ZServerThread)en.nextElement();
                if (!zThread.isAlive()) continue;
                zThread.halt(timeout);
            }
            this.waitForThreads(timeout);
            this.close();
        }
    }

    private void waitForThreads(long timeout) {
        if (this.hasThreads()) {
            Enumeration en = this.purgeThreads().elements();
            logger.debug(this.getName() + " active child threads: " + this.threads.size());
            while (en.hasMoreElements()) {
                ZServerThread zThread = (ZServerThread)en.nextElement();
                if (zThread.isAlive()) {
                    logger.debug(this.getName() + " waiting for child " + zThread.getName() + " to die (timeout " + timeout + ")");
                    try {
                        zThread.join(timeout);
                    }
                    catch (InterruptedException ex) {
                        logger.warn(this.getName() + " InterruptedException " + ex.toString());
                    }
                }
                if (zThread.isAlive()) continue;
                logger.debug(this.getName() + " child " + zThread.getName() + " is dead");
            }
        }
    }

    public void close() {
    }

    public int getNumberOfActiveThreads() {
        if (this.purgeThreads() == null) {
            return 0;
        }
        return this.threads.size();
    }

    public Vector getActiveThreads() {
        return this.purgeThreads();
    }

    public long getUpTime() {
        if (this.isStopping()) {
            return 0L;
        }
        return System.currentTimeMillis() / 1000L - this.startTime;
    }

    public int getThreadState() {
        if (this.isStopped()) {
            return STATE_STOPPED;
        }
        if (this.isStopping()) {
            return STATE_STOPPING;
        }
        return STATE_RUNNING;
    }
}

