/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver.operations;

import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import asn1.ASN1VisibleString;
import org.jafer.conf.Config;
import org.jafer.util.ConnectionException;
import org.jafer.util.PDUDriver;
import org.jafer.zserver.Session;
import org.jafer.zserver.ZServerThread;
import org.jafer.zserver.operations.OperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import z3950.v3.DefaultDiagFormat;
import z3950.v3.DefaultDiagFormat_addinfo;
import z3950.v3.DiagRec;
import z3950.v3.NamePlusRecord_record;
import z3950.v3.PDU;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Operation
extends ZServerThread {
    private static final Logger logger = LoggerFactory.getLogger(Operation.class);
    public static final String BIB1_DIAGNOSTIC_OID = "1.2.840.10003.4.1";
    protected final Session session;
    private final PDUDriver pduDriver;

    public Operation(Session session, String name) {
        super(name);
        this.session = session;
        this.pduDriver = session.getPDUDriver();
    }

    public final void start() {
        logger.debug(this.getName() + " starting...");
        this.setStopping(false);
        this.setStopped(false);
        this.setStartTime(System.currentTimeMillis() / 1000L);
        super.start();
    }

    public abstract PDU runOp() throws Exception;

    public final void run() {
        try {
            this.sendPDU(this.runOp());
        }
        catch (OperationException oe) {
            try {
                logger.warn(this.getName() + " ", (Throwable)oe);
                if (oe.hasPDUDiagnostic()) {
                    this.sendPDU(oe.getPDUDiagnostic());
                }
            }
            catch (ConnectionException ce) {
                logger.warn(this.getName() + " " + ce.toString());
            }
        }
        catch (Exception ex) {
            logger.error("Operation.run: " + this.getName(), (Throwable)ex);
        }
        finally {
            this.close();
        }
    }

    public final void close() {
        logger.debug(this.getName() + " stopping...");
        this.setStopping(true);
        this.setStopped(true);
    }

    public Session getSession() {
        return this.session;
    }

    private void sendPDU(PDU pduResponse) throws ConnectionException {
        this.pduDriver.sendPDU(pduResponse);
    }

    public static DefaultDiagFormat getDiagnostic(DefaultDiagFormat defaultDiagFormat, int condition, String addInfo) {
        defaultDiagFormat.s_diagnosticSetId = new ASN1ObjectIdentifier(Config.convertSyntax((String)"1.2.840.10003.4.1"));
        defaultDiagFormat.s_condition = new ASN1Integer(condition);
        (defaultDiagFormat.s_addinfo = new DefaultDiagFormat_addinfo()).c_v2Addinfo = new ASN1VisibleString(addInfo == null ? "" : addInfo);
        return defaultDiagFormat;
    }

    public static DiagRec getDiagnostic(DiagRec diagRec, int condition, String addInfo) {
        diagRec.c_defaultFormat = Operation.getDiagnostic((DefaultDiagFormat)new DefaultDiagFormat(), (int)condition, (String)addInfo);
        return diagRec;
    }

    protected NamePlusRecord_record getDiagnostic(NamePlusRecord_record name_record, int condition, String addInfo) {
        name_record.c_surrogateDiagnostic = Operation.getDiagnostic((DiagRec)new DiagRec(), (int)condition, (String)addInfo);
        return name_record;
    }
}

