/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver.operations;

import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1GeneralString;
import asn1.ASN1Integer;
import asn1.BEREncoding;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.record.DataObject;
import org.jafer.record.RecordFactory;
import org.jafer.util.xml.DOMFactory;
import org.jafer.zserver.Session;
import org.jafer.zserver.operations.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import z3950.v3.DatabaseName;
import z3950.v3.InternationalString;
import z3950.v3.NamePlusRecord;
import z3950.v3.NamePlusRecord_record;
import z3950.v3.PDU;
import z3950.v3.PresentResponse;
import z3950.v3.PresentStatus;
import z3950.v3.Records;

public class Present
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(Present.class);
    private static RecordFactory recordFactory;
    private final PDU pduRequest;
    private final PDU pduResponse;

    public Present(Session session, PDU pduRequest) {
        super(session, "present");
        this.pduRequest = pduRequest;
        String encoding = session.getEncoding();
        this.pduResponse = new PDU();
        recordFactory = new RecordFactory(encoding);
    }

    public PDU getBlankPduResponse() {
        PDU pduResponse = new PDU();
        pduResponse.c_presentResponse = new PresentResponse();
        pduResponse.c_presentResponse.s_referenceId = this.pduRequest.c_presentRequest.s_referenceId;
        pduResponse.c_presentResponse.s_nextResultSetPosition = new ASN1Integer(0);
        pduResponse.c_presentResponse.s_numberOfRecordsReturned = new ASN1Integer(0);
        return pduResponse;
    }

    public PDU runOp() throws Exception {
        this.pduResponse.c_presentResponse = new PresentResponse();
        this.pduResponse.c_presentResponse.s_referenceId = this.pduRequest.c_presentRequest.s_referenceId;
        this.pduResponse.c_presentResponse.s_nextResultSetPosition = new ASN1Integer(0);
        this.pduResponse.c_presentResponse.s_numberOfRecordsReturned = new ASN1Integer(0);
        PDU response = null;
        try {
            response = this.Present(this.pduRequest, this.pduResponse);
        }
        catch (Exception e) {
            return this.getErrorPDUResponse(this.pduResponse, e.getMessage(), 100);
        }
        return response;
    }

    private PDU getErrorPDUResponse(PDU pduResponse) {
        return this.getErrorPDUResponse(pduResponse, "general error", 100);
    }

    private PDU getErrorPDUResponse(PDU pduResponse, String message, int condition) {
        pduResponse.c_presentResponse.s_presentStatus = new PresentStatus();
        PresentStatus cfr_ignored_0 = pduResponse.c_presentResponse.s_presentStatus;
        pduResponse.c_presentResponse.s_presentStatus.value = new ASN1Integer(5);
        return pduResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDU Present(PDU pduRequest, PDU pduResponse) {
        org.jafer.interfaces.Present databean = null;
        String resultSetName = pduRequest.c_presentRequest.s_resultSetId.value == null ? "default" : pduRequest.c_presentRequest.s_resultSetId.value.value.get();
        databean = (org.jafer.interfaces.Present)this.getSession().getDatabean(resultSetName);
        if (databean == null) {
            logger.warn(this.getName() + " resultSet (" + resultSetName + ") for session " + this.getSession().getName() + " does not exist");
            return this.getErrorPDUResponse(pduResponse);
        }
        try {
            this.getSession().lockDatabean(resultSetName);
        }
        catch (JaferException ex) {
            logger.warn("selhani zamceni session " + this.getName(), (Object)ex.toString());
            return this.getErrorPDUResponse(pduResponse);
        }
        int start = pduRequest.c_presentRequest.s_resultSetStartPoint.get();
        int number = pduRequest.c_presentRequest.s_numberOfRecordsRequested.get();
        String requestedRecordSyntax = Config.convertSyntax((int[])pduRequest.c_presentRequest.s_preferredRecordSyntax.get());
        NamePlusRecord[] records = new NamePlusRecord[number];
        pduResponse.c_presentResponse.s_records = new Records();
        pduResponse.c_presentResponse.s_presentStatus = new PresentStatus();
        pduResponse.c_presentResponse.s_records.c_responseRecords = records;
        try {
            String recordSchema = Config.getRecordSerializerTargetSchema((String)requestedRecordSyntax);
            String recordSyntax = Config.getRecordSyntax((String)recordSchema);
            databean.setRecordSchema(recordSchema);
        }
        catch (JaferException ex) {
            logger.warn(this.getName() + " " + ex.toString(), (Throwable)ex);
            return this.getErrorPDUResponse(pduResponse);
        }
        int n = start;
        int recNo = 0;
        while (n < start + number) {
            PDU pDU;
            try {
                ASN1External asn1External;
                databean.setRecordCursor(n++);
                NamePlusRecord record = new NamePlusRecord();
                record.s_name = new DatabaseName();
                record.s_name.value = new InternationalString();
                record.s_name.value.value = new ASN1GeneralString(databean.getCurrentDatabase());
                record.s_record = new NamePlusRecord_record();
                Node recordRoot = databean.getCurrentRecord().getRoot();
                DataObject dataObject = new DataObject(databean.getCurrentDatabase(), recordRoot);
                BEREncoding ber = (BEREncoding)recordFactory.getBER(dataObject, DOMFactory.newDocument(), databean.getRecordCursor());
                record.s_record.c_retrievalRecord = asn1External = new ASN1External(ber, true);
                records[recNo++] = record;
            }
            catch (JaferException ex) {
                logger.warn(this.getName() + " recordNumber " + (n - 1) + ": " + ex.toString(), (Throwable)ex);
                pDU = this.getErrorPDUResponse(pduResponse, ex.toString(), 100);
                return pDU;
            }
            catch (ASN1Exception ex) {
                logger.warn(this.getName() + " recordNumber " + (n - 1) + ": " + ex.toString(), (Throwable)ex);
                pDU = this.getErrorPDUResponse(pduResponse);
                return pDU;
            }
            finally {
                try {
                    this.getSession().freeDatabean(resultSetName);
                }
                catch (Exception ex) {
                    logger.error("selhani operace present " + this.getName(), (Throwable)ex);
                    return this.getErrorPDUResponse(pduResponse, ex.getMessage(), 100);
                }
            }
        }
        pduResponse.c_presentResponse.s_nextResultSetPosition = new ASN1Integer(n);
        pduResponse.c_presentResponse.s_numberOfRecordsReturned = new ASN1Integer(recNo);
        if (recNo == number) {
            PresentStatus cfr_ignored_0 = pduResponse.c_presentResponse.s_presentStatus;
            pduResponse.c_presentResponse.s_presentStatus.value = new ASN1Integer(0);
        } else if (recNo == 0) {
            pduResponse.c_presentResponse.s_presentStatus = new PresentStatus();
            PresentStatus cfr_ignored_1 = pduResponse.c_presentResponse.s_presentStatus;
            pduResponse.c_presentResponse.s_presentStatus.value = new ASN1Integer(5);
            pduResponse.c_presentResponse.s_records.c_responseRecords = null;
        } else {
            PresentStatus cfr_ignored_2 = pduResponse.c_presentResponse.s_presentStatus;
            pduResponse.c_presentResponse.s_presentStatus.value = new ASN1Integer(1);
        }
        return pduResponse;
    }
}

