/*
 * Decompiled with CFR 0.152.
 */
package z3950.AccessCtrl_prompt;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1OctetString;
import asn1.BERConstructed;
import asn1.BEREncoding;

public final class Encryption
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1OctetString s_cryptType;
    public ASN1OctetString s_credential;
    public ASN1OctetString s_data;

    public Encryption() {
    }

    public Encryption(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis Encryption: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis Encryption: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_cryptType = new ASN1OctetString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis Encryption: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_credential = new ASN1OctetString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis Encryption: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 3 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis Encryption: bad tag in s_data\n");
        }
        this.s_data = new ASN1OctetString(berencoding1, false);
        if (++j < i) {
            throw new ASN1Exception("Verbis Encryption: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_cryptType != null) {
            ++k;
        }
        if (this.s_credential != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_cryptType != null) {
            aberencoding[l++] = this.s_cryptType.ber_encode(128, 1);
        }
        if (this.s_credential != null) {
            aberencoding[l++] = this.s_credential.ber_encode(128, 2);
        }
        aberencoding[l++] = this.s_data.ber_encode(128, 3);
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_cryptType != null) {
            stringbuffer.append("cryptType ");
            stringbuffer.append(this.s_cryptType);
            ++i;
        }
        if (this.s_credential != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("credential ");
            stringbuffer.append(this.s_credential);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("data ");
        stringbuffer.append(this.s_data);
        ++i;
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

