/*
 * Decompiled with CFR 0.152.
 */
package z3950.DiagFormat;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Null;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;

public final class DiagFormat_accessCtrl
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1Null c_noUser;
    public ASN1Null c_refused;
    public ASN1Null c_simple;
    public ASN1ObjectIdentifier[] c_oid;
    public ASN1ObjectIdentifier[] c_alternative;
    public ASN1Null c_pwdInv;
    public ASN1Null c_pwdExp;

    public DiagFormat_accessCtrl() {
    }

    public DiagFormat_accessCtrl(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_noUser = null;
        this.c_refused = null;
        this.c_simple = null;
        this.c_oid = null;
        this.c_alternative = null;
        this.c_pwdInv = null;
        this.c_pwdExp = null;
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            this.c_noUser = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 2 && berencoding.tag_type_get() == 128) {
            this.c_refused = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 3 && berencoding.tag_type_get() == 128) {
            this.c_simple = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 4 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed;
            BEREncoding berencoding1 = berencoding;
            try {
                berconstructed = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis DiagFormat_accessCtrl: bad BER form\n");
            }
            int i = berconstructed.number_components();
            this.c_oid = new ASN1ObjectIdentifier[i];
            for (int k = 0; k < i; ++k) {
                this.c_oid[k] = new ASN1ObjectIdentifier(berconstructed.elementAt(k), true);
            }
            return;
        }
        if (berencoding.tag_get() == 5 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            BEREncoding berencoding2 = berencoding;
            try {
                berconstructed1 = (BERConstructed)berencoding2;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis DiagFormat_accessCtrl: bad BER form\n");
            }
            int j = berconstructed1.number_components();
            this.c_alternative = new ASN1ObjectIdentifier[j];
            for (int l = 0; l < j; ++l) {
                this.c_alternative[l] = new ASN1ObjectIdentifier(berconstructed1.elementAt(l), true);
            }
            return;
        }
        if (berencoding.tag_get() == 6 && berencoding.tag_type_get() == 128) {
            this.c_pwdInv = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 7 && berencoding.tag_type_get() == 128) {
            this.c_pwdExp = new ASN1Null(berencoding, false);
            return;
        }
        throw new ASN1Exception("Verbis DiagFormat_accessCtrl: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding obj = null;
        if (this.c_noUser != null) {
            obj = this.c_noUser.ber_encode(128, 1);
        }
        if (this.c_refused != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_refused.ber_encode(128, 2);
        }
        if (this.c_simple != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_simple.ber_encode(128, 3);
        }
        if (this.c_oid != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding = new BEREncoding[this.c_oid.length];
            for (int i = 0; i < this.c_oid.length; ++i) {
                aberencoding[i] = this.c_oid[i].ber_encode();
            }
            obj = new BERConstructed(128, 4, aberencoding);
        }
        if (this.c_alternative != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding1 = new BEREncoding[this.c_alternative.length];
            for (int j = 0; j < this.c_alternative.length; ++j) {
                aberencoding1[j] = this.c_alternative[j].ber_encode();
            }
            obj = new BERConstructed(128, 5, aberencoding1);
        }
        if (this.c_pwdInv != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_pwdInv.ber_encode(128, 6);
        }
        if (this.c_pwdExp != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_pwdExp.ber_encode(128, 7);
        }
        if (obj == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return obj;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis DiagFormat_accessCtrl: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_noUser != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: noUser> ");
            }
            flag = true;
            stringbuffer.append("noUser ");
            stringbuffer.append(this.c_noUser);
        }
        if (this.c_refused != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: refused> ");
            }
            flag = true;
            stringbuffer.append("refused ");
            stringbuffer.append(this.c_refused);
        }
        if (this.c_simple != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: simple> ");
            }
            flag = true;
            stringbuffer.append("simple ");
            stringbuffer.append(this.c_simple);
        }
        if (this.c_oid != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: oid> ");
            }
            flag = true;
            stringbuffer.append("oid ");
            stringbuffer.append("{");
            for (int i = 0; i < this.c_oid.length; ++i) {
                stringbuffer.append(this.c_oid[i]);
            }
            stringbuffer.append("}");
        }
        if (this.c_alternative != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: alternative> ");
            }
            flag = true;
            stringbuffer.append("alternative ");
            stringbuffer.append("{");
            for (int j = 0; j < this.c_alternative.length; ++j) {
                stringbuffer.append(this.c_alternative[j]);
            }
            stringbuffer.append("}");
        }
        if (this.c_pwdInv != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: pwdInv> ");
            }
            flag = true;
            stringbuffer.append("pwdInv ");
            stringbuffer.append(this.c_pwdInv);
        }
        if (this.c_pwdExp != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: pwdExp> ");
            }
            flag = true;
            stringbuffer.append("pwdExp ");
            stringbuffer.append(this.c_pwdExp);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

