/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Null;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.HumanString;
import z3950.v3.StringOrNumeric;

public final class AttributeValue
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public StringOrNumeric s_value;
    public HumanString s_description;
    public StringOrNumeric[] s_subAttributes;
    public StringOrNumeric[] s_superAttributes;
    public ASN1Null s_partialSupport;

    public AttributeValue() {
    }

    public AttributeValue(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed1;
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis AttributeValue: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis AttributeValue: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 0 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis AttributeValue: bad tag in s_value\n");
        }
        try {
            berconstructed1 = (BERConstructed)berencoding1;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis AttributeValue: bad BER encoding: s_value tag bad\n");
        }
        if (berconstructed1.number_components() != 1) {
            throw new ASN1EncodingException("Verbis AttributeValue: bad BER encoding: s_value tag bad\n");
        }
        this.s_value = new StringOrNumeric(berconstructed1.elementAt(0), true);
        this.s_description = null;
        this.s_subAttributes = null;
        this.s_superAttributes = null;
        this.s_partialSupport = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_description = new HumanString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed2 = (BERConstructed)berencoding1;
                int k = berconstructed2.number_components();
                this.s_subAttributes = new StringOrNumeric[k];
                for (int i1 = 0; i1 < k; ++i1) {
                    this.s_subAttributes[i1] = new StringOrNumeric(berconstructed2.elementAt(i1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed3 = (BERConstructed)berencoding1;
                int l = berconstructed3.number_components();
                this.s_superAttributes = new StringOrNumeric[l];
                for (int j1 = 0; j1 < l; ++j1) {
                    this.s_superAttributes[j1] = new StringOrNumeric(berconstructed3.elementAt(j1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            this.s_partialSupport = new ASN1Null(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis AttributeValue: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_description != null) {
            ++k;
        }
        if (this.s_subAttributes != null) {
            ++k;
        }
        if (this.s_superAttributes != null) {
            ++k;
        }
        if (this.s_partialSupport != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        BEREncoding[] aberencoding3 = new BEREncoding[]{this.s_value.ber_encode()};
        aberencoding[l++] = new BERConstructed(128, 0, aberencoding3);
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 1);
        }
        if (this.s_subAttributes != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_subAttributes.length];
            for (int i1 = 0; i1 < this.s_subAttributes.length; ++i1) {
                aberencoding1[i1] = this.s_subAttributes[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 2, aberencoding1);
        }
        if (this.s_superAttributes != null) {
            BEREncoding[] aberencoding2 = new BEREncoding[this.s_superAttributes.length];
            for (int j1 = 0; j1 < this.s_superAttributes.length; ++j1) {
                aberencoding2[j1] = this.s_superAttributes[j1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 3, aberencoding2);
        }
        if (this.s_partialSupport != null) {
            aberencoding[l++] = this.s_partialSupport.ber_encode(128, 4);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int k = 0;
        stringbuffer.append("value ");
        stringbuffer.append(this.s_value);
        ++k;
        if (this.s_description != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++k;
        }
        if (this.s_subAttributes != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("subAttributes ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_subAttributes.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_subAttributes[i]);
            }
            stringbuffer.append("}");
            ++k;
        }
        if (this.s_superAttributes != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("superAttributes ");
            stringbuffer.append("{");
            for (int j = 0; j < this.s_superAttributes.length; ++j) {
                if (j != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_superAttributes[j]);
            }
            stringbuffer.append("}");
            ++k;
        }
        if (this.s_partialSupport != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("partialSupport ");
            stringbuffer.append(this.s_partialSupport);
            ++k;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

