/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.HumanString;
import z3950.v3.IntUnit;
import z3950.v3.Unit;

public final class Charge
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public IntUnit s_cost;
    public Unit s_perWhat;
    public HumanString s_text;

    public Charge() {
    }

    public Charge(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis Charge: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis Charge: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis Charge: bad tag in s_cost\n");
        }
        this.s_cost = new IntUnit(berencoding1, false);
        this.s_perWhat = null;
        this.s_text = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_perWhat = new Unit(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_text = new HumanString(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis Charge: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_perWhat != null) {
            ++k;
        }
        if (this.s_text != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        aberencoding[l++] = this.s_cost.ber_encode(128, 1);
        if (this.s_perWhat != null) {
            aberencoding[l++] = this.s_perWhat.ber_encode(128, 2);
        }
        if (this.s_text != null) {
            aberencoding[l++] = this.s_text.ber_encode(128, 3);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        stringbuffer.append("cost ");
        stringbuffer.append(this.s_cost);
        ++i;
        if (this.s_perWhat != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("perWhat ");
            stringbuffer.append(this.s_perWhat);
            ++i;
        }
        if (this.s_text != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("text ");
            stringbuffer.append(this.s_text);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

