/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1Boolean;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.ElementDataType;
import z3950.RS_Explain.HumanString;
import z3950.RS_Explain.Path;
import z3950.v3.InternationalString;

public final class ElementInfo
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public InternationalString s_elementName;
    public Path s_elementTagPath;
    public ElementDataType s_dataType;
    public ASN1Boolean s_required;
    public ASN1Boolean s_repeatable;
    public HumanString s_description;

    public ElementInfo() {
    }

    public ElementInfo(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ElementInfo: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis ElementInfo: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ElementInfo: bad tag in s_elementName\n");
        }
        this.s_elementName = new InternationalString(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ElementInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ElementInfo: bad tag in s_elementTagPath\n");
        }
        this.s_elementTagPath = new Path(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ElementInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            try {
                berconstructed1 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis ElementInfo: bad BER encoding: s_dataType tag bad\n");
            }
            if (berconstructed1.number_components() != 1) {
                throw new ASN1EncodingException("Verbis ElementInfo: bad BER encoding: s_dataType tag bad\n");
            }
            this.s_dataType = new ElementDataType(berconstructed1.elementAt(0), true);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ElementInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 4 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ElementInfo: bad tag in s_required\n");
        }
        this.s_required = new ASN1Boolean(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ElementInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 5 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ElementInfo: bad tag in s_repeatable\n");
        }
        this.s_repeatable = new ASN1Boolean(berencoding1, false);
        this.s_description = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 6 && berencoding1.tag_type_get() == 128) {
            this.s_description = new HumanString(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ElementInfo: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 4;
        if (this.s_dataType != null) {
            ++k;
        }
        if (this.s_description != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        aberencoding[l++] = this.s_elementName.ber_encode(128, 1);
        aberencoding[l++] = this.s_elementTagPath.ber_encode(128, 2);
        if (this.s_dataType != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[]{this.s_dataType.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 3, aberencoding1);
        }
        aberencoding[l++] = this.s_required.ber_encode(128, 4);
        aberencoding[l++] = this.s_repeatable.ber_encode(128, 5);
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 6);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        stringbuffer.append("elementName ");
        stringbuffer.append(this.s_elementName);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("elementTagPath ");
        stringbuffer.append(this.s_elementTagPath);
        ++i;
        if (this.s_dataType != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("dataType ");
            stringbuffer.append(this.s_dataType);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("required ");
        stringbuffer.append(this.s_required);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("repeatable ");
        stringbuffer.append(this.s_repeatable);
        ++i;
        if (this.s_description != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

