/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.CommonInfo;
import z3950.RS_Explain.HumanString;
import z3950.v3.DatabaseName;
import z3950.v3.InternationalString;

public final class ProcessingInformation
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public CommonInfo s_commonInfo;
    public DatabaseName s_databaseName;
    public ASN1Integer s_processingContext;
    public InternationalString s_name;
    public ASN1ObjectIdentifier s_oid;
    public HumanString s_description;
    public ASN1External s_instructions;
    public static final int E_access = 0;
    public static final int E_search = 1;
    public static final int E_retrieval = 2;
    public static final int E_record_presentation = 3;
    public static final int E_record_handling = 4;

    public ProcessingInformation() {
    }

    public ProcessingInformation(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ProcessingInformation: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis ProcessingInformation: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            this.s_commonInfo = new CommonInfo(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ProcessingInformation: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ProcessingInformation: bad tag in s_databaseName\n");
        }
        this.s_databaseName = new DatabaseName(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ProcessingInformation: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ProcessingInformation: bad tag in s_processingContext\n");
        }
        this.s_processingContext = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ProcessingInformation: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 3 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ProcessingInformation: bad tag in s_name\n");
        }
        this.s_name = new InternationalString(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ProcessingInformation: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 4 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ProcessingInformation: bad tag in s_oid\n");
        }
        this.s_oid = new ASN1ObjectIdentifier(berencoding1, false);
        this.s_description = null;
        this.s_instructions = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 5 && berencoding1.tag_type_get() == 128) {
            this.s_description = new HumanString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 6 && berencoding1.tag_type_get() == 128) {
            this.s_instructions = new ASN1External(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ProcessingInformation: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 4;
        if (this.s_commonInfo != null) {
            ++k;
        }
        if (this.s_description != null) {
            ++k;
        }
        if (this.s_instructions != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_commonInfo != null) {
            aberencoding[l++] = this.s_commonInfo.ber_encode(128, 0);
        }
        aberencoding[l++] = this.s_databaseName.ber_encode(128, 1);
        aberencoding[l++] = this.s_processingContext.ber_encode(128, 2);
        aberencoding[l++] = this.s_name.ber_encode(128, 3);
        aberencoding[l++] = this.s_oid.ber_encode(128, 4);
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 5);
        }
        if (this.s_instructions != null) {
            aberencoding[l++] = this.s_instructions.ber_encode(128, 6);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_commonInfo != null) {
            stringbuffer.append("commonInfo ");
            stringbuffer.append(this.s_commonInfo);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("databaseName ");
        stringbuffer.append(this.s_databaseName);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("processingContext ");
        stringbuffer.append(this.s_processingContext);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("name ");
        stringbuffer.append(this.s_name);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("oid ");
        stringbuffer.append(this.s_oid);
        ++i;
        if (this.s_description != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++i;
        }
        if (this.s_instructions != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("instructions ");
            stringbuffer.append(this.s_instructions);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

