/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.CommonInfo;
import z3950.RS_Explain.ElementInfo;
import z3950.RS_Explain.HumanString;
import z3950.RS_Explain.SchemaInfo_tagTypeMapping;
import z3950.v3.InternationalString;

public final class SchemaInfo
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public CommonInfo s_commonInfo;
    public ASN1ObjectIdentifier s_schema;
    public InternationalString s_name;
    public HumanString s_description;
    public SchemaInfo_tagTypeMapping[] s_tagTypeMapping;
    public ElementInfo[] s_recordStructure;

    public SchemaInfo() {
    }

    public SchemaInfo(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis SchemaInfo: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis SchemaInfo: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            this.s_commonInfo = new CommonInfo(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis SchemaInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SchemaInfo: bad tag in s_schema\n");
        }
        this.s_schema = new ASN1ObjectIdentifier(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis SchemaInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SchemaInfo: bad tag in s_name\n");
        }
        this.s_name = new InternationalString(berencoding1, false);
        this.s_description = null;
        this.s_tagTypeMapping = null;
        this.s_recordStructure = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_description = new HumanString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_tagTypeMapping = new SchemaInfo_tagTypeMapping[k];
                for (int i1 = 0; i1 < k; ++i1) {
                    this.s_tagTypeMapping[i1] = new SchemaInfo_tagTypeMapping(berconstructed1.elementAt(i1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 5 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed2 = (BERConstructed)berencoding1;
                int l = berconstructed2.number_components();
                this.s_recordStructure = new ElementInfo[l];
                for (int j1 = 0; j1 < l; ++j1) {
                    this.s_recordStructure[j1] = new ElementInfo(berconstructed2.elementAt(j1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis SchemaInfo: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_commonInfo != null) {
            ++k;
        }
        if (this.s_description != null) {
            ++k;
        }
        if (this.s_tagTypeMapping != null) {
            ++k;
        }
        if (this.s_recordStructure != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_commonInfo != null) {
            aberencoding[l++] = this.s_commonInfo.ber_encode(128, 0);
        }
        aberencoding[l++] = this.s_schema.ber_encode(128, 1);
        aberencoding[l++] = this.s_name.ber_encode(128, 2);
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 3);
        }
        if (this.s_tagTypeMapping != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_tagTypeMapping.length];
            for (int i1 = 0; i1 < this.s_tagTypeMapping.length; ++i1) {
                aberencoding1[i1] = this.s_tagTypeMapping[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 4, aberencoding1);
        }
        if (this.s_recordStructure != null) {
            BEREncoding[] aberencoding2 = new BEREncoding[this.s_recordStructure.length];
            for (int j1 = 0; j1 < this.s_recordStructure.length; ++j1) {
                aberencoding2[j1] = this.s_recordStructure[j1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 5, aberencoding2);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int k = 0;
        if (this.s_commonInfo != null) {
            stringbuffer.append("commonInfo ");
            stringbuffer.append(this.s_commonInfo);
            ++k;
        }
        if (k > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("schema ");
        stringbuffer.append(this.s_schema);
        if (++k > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("name ");
        stringbuffer.append(this.s_name);
        ++k;
        if (this.s_description != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++k;
        }
        if (this.s_tagTypeMapping != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("tagTypeMapping ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_tagTypeMapping.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_tagTypeMapping[i]);
            }
            stringbuffer.append("}");
            ++k;
        }
        if (this.s_recordStructure != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("recordStructure ");
            stringbuffer.append("{");
            for (int j = 0; j < this.s_recordStructure.length; ++j) {
                if (j != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_recordStructure[j]);
            }
            stringbuffer.append("}");
            ++k;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

