/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.AttributeCombinations;
import z3950.RS_Explain.HumanString;
import z3950.RS_Explain.SortKeyDetails_sortType;
import z3950.v3.Specification;

public final class SortKeyDetails
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public HumanString s_description;
    public Specification[] s_elementSpecifications;
    public AttributeCombinations s_attributeSpecifications;
    public SortKeyDetails_sortType s_sortType;
    public ASN1Integer s_caseSensitivity;
    public static final int E_always = 0;
    public static final int E_never = 1;
    public static final int E_default_yes = 2;
    public static final int E_default_no = 3;

    public SortKeyDetails() {
    }

    public SortKeyDetails(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis SortKeyDetails: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_description = null;
        this.s_elementSpecifications = null;
        this.s_attributeSpecifications = null;
        this.s_sortType = null;
        this.s_caseSensitivity = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            this.s_description = new HumanString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed2 = (BERConstructed)berencoding1;
                int k = berconstructed2.number_components();
                this.s_elementSpecifications = new Specification[k];
                for (int l = 0; l < k; ++l) {
                    this.s_elementSpecifications[l] = new Specification(berconstructed2.elementAt(l), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_attributeSpecifications = new AttributeCombinations(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            try {
                berconstructed1 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis SortKeyDetails: bad BER encoding: s_sortType tag bad\n");
            }
            if (berconstructed1.number_components() != 1) {
                throw new ASN1EncodingException("Verbis SortKeyDetails: bad BER encoding: s_sortType tag bad\n");
            }
            this.s_sortType = new SortKeyDetails_sortType(berconstructed1.elementAt(0), true);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            this.s_caseSensitivity = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis SortKeyDetails: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_description != null) {
            ++k;
        }
        if (this.s_elementSpecifications != null) {
            ++k;
        }
        if (this.s_attributeSpecifications != null) {
            ++k;
        }
        if (this.s_sortType != null) {
            ++k;
        }
        if (this.s_caseSensitivity != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 0);
        }
        if (this.s_elementSpecifications != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_elementSpecifications.length];
            for (int i1 = 0; i1 < this.s_elementSpecifications.length; ++i1) {
                aberencoding1[i1] = this.s_elementSpecifications[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 1, aberencoding1);
        }
        if (this.s_attributeSpecifications != null) {
            aberencoding[l++] = this.s_attributeSpecifications.ber_encode(128, 2);
        }
        if (this.s_sortType != null) {
            BEREncoding[] aberencoding2 = new BEREncoding[]{this.s_sortType.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 3, aberencoding2);
        }
        if (this.s_caseSensitivity != null) {
            aberencoding[l++] = this.s_caseSensitivity.ber_encode(128, 4);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_description != null) {
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++j;
        }
        if (this.s_elementSpecifications != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("elementSpecifications ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_elementSpecifications.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_elementSpecifications[i]);
            }
            stringbuffer.append("}");
            ++j;
        }
        if (this.s_attributeSpecifications != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("attributeSpecifications ");
            stringbuffer.append(this.s_attributeSpecifications);
            ++j;
        }
        if (this.s_sortType != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("sortType ");
            stringbuffer.append(this.s_sortType);
            ++j;
        }
        if (this.s_caseSensitivity != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("caseSensitivity ");
            stringbuffer.append(this.s_caseSensitivity);
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

