/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.CommonInfo;
import z3950.RS_Explain.HumanString;
import z3950.RS_Explain.TagSetInfo_elements;
import z3950.v3.InternationalString;

public final class TagSetInfo
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public CommonInfo s_commonInfo;
    public ASN1ObjectIdentifier s_tagSet;
    public InternationalString s_name;
    public HumanString s_description;
    public TagSetInfo_elements[] s_elements;

    public TagSetInfo() {
    }

    public TagSetInfo(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis TagSetInfo: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis TagSetInfo: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            this.s_commonInfo = new CommonInfo(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TagSetInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis TagSetInfo: bad tag in s_tagSet\n");
        }
        this.s_tagSet = new ASN1ObjectIdentifier(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis TagSetInfo: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis TagSetInfo: bad tag in s_name\n");
        }
        this.s_name = new InternationalString(berencoding1, false);
        this.s_description = null;
        this.s_elements = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_description = new HumanString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_elements = new TagSetInfo_elements[k];
                for (int l = 0; l < k; ++l) {
                    this.s_elements[l] = new TagSetInfo_elements(berconstructed1.elementAt(l), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis TagSetInfo: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_commonInfo != null) {
            ++k;
        }
        if (this.s_description != null) {
            ++k;
        }
        if (this.s_elements != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_commonInfo != null) {
            aberencoding[l++] = this.s_commonInfo.ber_encode(128, 0);
        }
        aberencoding[l++] = this.s_tagSet.ber_encode(128, 1);
        aberencoding[l++] = this.s_name.ber_encode(128, 2);
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 3);
        }
        if (this.s_elements != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_elements.length];
            for (int i1 = 0; i1 < this.s_elements.length; ++i1) {
                aberencoding1[i1] = this.s_elements[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 4, aberencoding1);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_commonInfo != null) {
            stringbuffer.append("commonInfo ");
            stringbuffer.append(this.s_commonInfo);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("tagSet ");
        stringbuffer.append(this.s_tagSet);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("name ");
        stringbuffer.append(this.s_name);
        ++j;
        if (this.s_description != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++j;
        }
        if (this.s_elements != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("elements ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_elements.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_elements[i]);
            }
            stringbuffer.append("}");
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

