/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.HumanString;
import z3950.RS_Explain.Units;
import z3950.v3.InternationalString;
import z3950.v3.StringOrNumeric;

public final class UnitType
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public InternationalString s_name;
    public HumanString s_description;
    public StringOrNumeric s_unitType;
    public Units[] s_units;

    public UnitType() {
    }

    public UnitType(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed1;
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis UnitType: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis UnitType: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            this.s_name = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis UnitType: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_description = new HumanString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis UnitType: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis UnitType: bad tag in s_unitType\n");
        }
        try {
            berconstructed1 = (BERConstructed)berencoding1;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis UnitType: bad BER encoding: s_unitType tag bad\n");
        }
        if (berconstructed1.number_components() != 1) {
            throw new ASN1EncodingException("Verbis UnitType: bad BER encoding: s_unitType tag bad\n");
        }
        this.s_unitType = new StringOrNumeric(berconstructed1.elementAt(0), true);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis UnitType: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 3 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis UnitType: bad tag in s_units\n");
        }
        try {
            BERConstructed berconstructed2 = (BERConstructed)berencoding1;
            int k = berconstructed2.number_components();
            this.s_units = new Units[k];
            for (int l = 0; l < k; ++l) {
                this.s_units[l] = new Units(berconstructed2.elementAt(l), true);
            }
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Bad BER");
        }
        if (++j < i) {
            throw new ASN1Exception("Verbis UnitType: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_name != null) {
            ++k;
        }
        if (this.s_description != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_name != null) {
            aberencoding[l++] = this.s_name.ber_encode(128, 0);
        }
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 1);
        }
        BEREncoding[] aberencoding2 = new BEREncoding[]{this.s_unitType.ber_encode()};
        aberencoding[l++] = new BERConstructed(128, 2, aberencoding2);
        BEREncoding[] aberencoding1 = new BEREncoding[this.s_units.length];
        for (int i1 = 0; i1 < this.s_units.length; ++i1) {
            aberencoding1[i1] = this.s_units[i1].ber_encode();
        }
        aberencoding[l++] = new BERConstructed(128, 3, aberencoding1);
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_name != null) {
            stringbuffer.append("name ");
            stringbuffer.append(this.s_name);
            ++j;
        }
        if (this.s_description != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("unitType ");
        stringbuffer.append(this.s_unitType);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("units ");
        stringbuffer.append("{");
        for (int i = 0; i < this.s_units.length; ++i) {
            if (i != 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append(this.s_units[i]);
        }
        stringbuffer.append("}");
        ++j;
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

