/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import asn1.ASN1OctetString;
import asn1.BEREncoding;
import z3950.v3.IntUnit;
import z3950.v3.InternationalString;
import z3950.v3.Unit;

public final class ValueDescription
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1Integer c_integer;
    public InternationalString c_string;
    public ASN1OctetString c_octets;
    public ASN1ObjectIdentifier c_oid;
    public Unit c_unit;
    public IntUnit c_valueAndUnit;

    public ValueDescription() {
    }

    public ValueDescription(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_integer = null;
        this.c_string = null;
        this.c_octets = null;
        this.c_oid = null;
        this.c_unit = null;
        this.c_valueAndUnit = null;
        try {
            this.c_integer = new ASN1Integer(berencoding, flag);
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            try {
                this.c_string = new InternationalString(berencoding, flag);
                return;
            }
            catch (ASN1Exception aSN1Exception2) {
                try {
                    this.c_octets = new ASN1OctetString(berencoding, flag);
                    return;
                }
                catch (ASN1Exception aSN1Exception3) {
                    try {
                        this.c_oid = new ASN1ObjectIdentifier(berencoding, flag);
                        return;
                    }
                    catch (ASN1Exception aSN1Exception4) {
                        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
                            this.c_unit = new Unit(berencoding, false);
                            return;
                        }
                        if (berencoding.tag_get() == 2 && berencoding.tag_type_get() == 128) {
                            this.c_valueAndUnit = new IntUnit(berencoding, false);
                            return;
                        }
                        throw new ASN1Exception("Verbis ValueDescription: bad BER encoding: choice not matched");
                    }
                }
            }
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding berencoding = null;
        if (this.c_integer != null) {
            berencoding = this.c_integer.ber_encode();
        }
        if (this.c_string != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_string.ber_encode();
        }
        if (this.c_octets != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_octets.ber_encode();
        }
        if (this.c_oid != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_oid.ber_encode();
        }
        if (this.c_unit != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_unit.ber_encode(128, 1);
        }
        if (this.c_valueAndUnit != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_valueAndUnit.ber_encode(128, 2);
        }
        if (berencoding == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return berencoding;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis ValueDescription: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_integer != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: integer> ");
            }
            flag = true;
            stringbuffer.append("integer ");
            stringbuffer.append(this.c_integer);
        }
        if (this.c_string != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: string> ");
            }
            flag = true;
            stringbuffer.append("string ");
            stringbuffer.append(this.c_string);
        }
        if (this.c_octets != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: octets> ");
            }
            flag = true;
            stringbuffer.append("octets ");
            stringbuffer.append(this.c_octets);
        }
        if (this.c_oid != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: oid> ");
            }
            flag = true;
            stringbuffer.append("oid ");
            stringbuffer.append(this.c_oid);
        }
        if (this.c_unit != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: unit> ");
            }
            flag = true;
            stringbuffer.append("unit ");
            stringbuffer.append(this.c_unit);
        }
        if (this.c_valueAndUnit != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: valueAndUnit> ");
            }
            flag = true;
            stringbuffer.append("valueAndUnit ");
            stringbuffer.append(this.c_valueAndUnit);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

