/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.ValueDescription;
import z3950.RS_Explain.ValueRange;

public final class ValueSet
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ValueRange c_range;
    public ValueDescription[] c_enumerated;

    public ValueSet() {
    }

    public ValueSet(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_range = null;
        this.c_enumerated = null;
        if (berencoding.tag_get() == 0 && berencoding.tag_type_get() == 128) {
            this.c_range = new ValueRange(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed;
            BEREncoding berencoding1 = berencoding;
            try {
                berconstructed = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis ValueSet: bad BER form\n");
            }
            int i = berconstructed.number_components();
            this.c_enumerated = new ValueDescription[i];
            for (int j = 0; j < i; ++j) {
                this.c_enumerated[j] = new ValueDescription(berconstructed.elementAt(j), true);
            }
            return;
        }
        throw new ASN1Exception("Verbis ValueSet: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding obj = null;
        if (this.c_range != null) {
            obj = this.c_range.ber_encode(128, 0);
        }
        if (this.c_enumerated != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding = new BEREncoding[this.c_enumerated.length];
            for (int i = 0; i < this.c_enumerated.length; ++i) {
                aberencoding[i] = this.c_enumerated[i].ber_encode();
            }
            obj = new BERConstructed(128, 1, aberencoding);
        }
        if (obj == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return obj;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis ValueSet: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_range != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: range> ");
            }
            flag = true;
            stringbuffer.append("range ");
            stringbuffer.append(this.c_range);
        }
        if (this.c_enumerated != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: enumerated> ");
            }
            flag = true;
            stringbuffer.append("enumerated ");
            stringbuffer.append("{");
            for (int i = 0; i < this.c_enumerated.length; ++i) {
                stringbuffer.append(this.c_enumerated[i]);
            }
            stringbuffer.append("}");
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

