/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_generic;

import asn1.ASN1Any;
import asn1.ASN1Boolean;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1GeneralizedTime;
import asn1.ASN1Integer;
import asn1.ASN1Null;
import asn1.ASN1ObjectIdentifier;
import asn1.ASN1OctetString;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_generic.TaggedElement;
import z3950.v3.IntUnit;
import z3950.v3.InternationalString;

public final class ElementData
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1OctetString c_octets;
    public ASN1Integer c_numeric;
    public ASN1GeneralizedTime c_date;
    public ASN1External c_ext;
    public InternationalString c_string;
    public ASN1Boolean c_trueOrFalse;
    public ASN1ObjectIdentifier c_oid;
    public IntUnit c_intUnit;
    public ASN1Null c_elementNotThere;
    public ASN1Null c_elementEmpty;
    public ASN1Null c_noDataRequested;
    public ASN1External c_diagnostic;
    public TaggedElement[] c_subtree;

    public ElementData() {
    }

    public ElementData(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_octets = null;
        this.c_numeric = null;
        this.c_date = null;
        this.c_ext = null;
        this.c_string = null;
        this.c_trueOrFalse = null;
        this.c_oid = null;
        this.c_intUnit = null;
        this.c_elementNotThere = null;
        this.c_elementEmpty = null;
        this.c_noDataRequested = null;
        this.c_diagnostic = null;
        this.c_subtree = null;
        try {
            this.c_octets = new ASN1OctetString(berencoding, flag);
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            try {
                this.c_numeric = new ASN1Integer(berencoding, flag);
                return;
            }
            catch (ASN1Exception aSN1Exception2) {
                try {
                    this.c_date = new ASN1GeneralizedTime(berencoding, flag);
                    return;
                }
                catch (ASN1Exception aSN1Exception3) {
                    try {
                        this.c_ext = new ASN1External(berencoding, flag);
                        return;
                    }
                    catch (ASN1Exception aSN1Exception4) {
                        try {
                            this.c_string = new InternationalString(berencoding, flag);
                            return;
                        }
                        catch (ASN1Exception aSN1Exception5) {
                            try {
                                this.c_trueOrFalse = new ASN1Boolean(berencoding, flag);
                                return;
                            }
                            catch (ASN1Exception aSN1Exception6) {
                                try {
                                    this.c_oid = new ASN1ObjectIdentifier(berencoding, flag);
                                    return;
                                }
                                catch (ASN1Exception aSN1Exception7) {
                                    if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
                                        this.c_intUnit = new IntUnit(berencoding, false);
                                        return;
                                    }
                                    if (berencoding.tag_get() == 2 && berencoding.tag_type_get() == 128) {
                                        this.c_elementNotThere = new ASN1Null(berencoding, false);
                                        return;
                                    }
                                    if (berencoding.tag_get() == 3 && berencoding.tag_type_get() == 128) {
                                        this.c_elementEmpty = new ASN1Null(berencoding, false);
                                        return;
                                    }
                                    if (berencoding.tag_get() == 4 && berencoding.tag_type_get() == 128) {
                                        this.c_noDataRequested = new ASN1Null(berencoding, false);
                                        return;
                                    }
                                    if (berencoding.tag_get() == 5 && berencoding.tag_type_get() == 128) {
                                        this.c_diagnostic = new ASN1External(berencoding, false);
                                        return;
                                    }
                                    if (berencoding.tag_get() == 6 && berencoding.tag_type_get() == 128) {
                                        BERConstructed berconstructed1;
                                        BERConstructed berconstructed;
                                        try {
                                            berconstructed = (BERConstructed)berencoding;
                                        }
                                        catch (ClassCastException _ex) {
                                            throw new ASN1EncodingException("Verbis ElementData: bad BER form\n");
                                        }
                                        if (berconstructed.number_components() != 1) {
                                            throw new ASN1EncodingException("Verbis ElementData: bad BER form\n");
                                        }
                                        BEREncoding berencoding1 = berconstructed.elementAt(0);
                                        try {
                                            berconstructed1 = (BERConstructed)berencoding1;
                                        }
                                        catch (ClassCastException _ex) {
                                            throw new ASN1EncodingException("Verbis ElementData: bad BER form\n");
                                        }
                                        int i = berconstructed1.number_components();
                                        this.c_subtree = new TaggedElement[i];
                                        for (int j = 0; j < i; ++j) {
                                            this.c_subtree[j] = new TaggedElement(berconstructed1.elementAt(j), true);
                                        }
                                        return;
                                    }
                                    throw new ASN1Exception("Verbis ElementData: bad BER encoding: choice not matched");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding obj = null;
        if (this.c_octets != null) {
            obj = this.c_octets.ber_encode();
        }
        if (this.c_numeric != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_numeric.ber_encode();
        }
        if (this.c_date != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_date.ber_encode();
        }
        if (this.c_ext != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_ext.ber_encode();
        }
        if (this.c_string != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_string.ber_encode();
        }
        if (this.c_trueOrFalse != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_trueOrFalse.ber_encode();
        }
        if (this.c_oid != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_oid.ber_encode();
        }
        if (this.c_intUnit != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_intUnit.ber_encode(128, 1);
        }
        if (this.c_elementNotThere != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_elementNotThere.ber_encode(128, 2);
        }
        if (this.c_elementEmpty != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_elementEmpty.ber_encode(128, 3);
        }
        if (this.c_noDataRequested != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_noDataRequested.ber_encode(128, 4);
        }
        if (this.c_diagnostic != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_diagnostic.ber_encode(128, 5);
        }
        if (this.c_subtree != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding1 = new BEREncoding[1];
            BEREncoding[] aberencoding = new BEREncoding[this.c_subtree.length];
            for (int i = 0; i < this.c_subtree.length; ++i) {
                aberencoding[i] = this.c_subtree[i].ber_encode();
            }
            aberencoding1[0] = new BERConstructed(0, 16, aberencoding);
            obj = new BERConstructed(128, 6, aberencoding1);
        }
        if (obj == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return obj;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis ElementData: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_octets != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: octets> ");
            }
            flag = true;
            stringbuffer.append("octets ");
            stringbuffer.append(this.c_octets);
        }
        if (this.c_numeric != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: numeric> ");
            }
            flag = true;
            stringbuffer.append("numeric ");
            stringbuffer.append(this.c_numeric);
        }
        if (this.c_date != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: date> ");
            }
            flag = true;
            stringbuffer.append("date ");
            stringbuffer.append(this.c_date);
        }
        if (this.c_ext != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: ext> ");
            }
            flag = true;
            stringbuffer.append("ext ");
            stringbuffer.append(this.c_ext);
        }
        if (this.c_string != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: string> ");
            }
            flag = true;
            stringbuffer.append("string ");
            stringbuffer.append(this.c_string);
        }
        if (this.c_trueOrFalse != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: trueOrFalse> ");
            }
            flag = true;
            stringbuffer.append("trueOrFalse ");
            stringbuffer.append(this.c_trueOrFalse);
        }
        if (this.c_oid != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: oid> ");
            }
            flag = true;
            stringbuffer.append("oid ");
            stringbuffer.append(this.c_oid);
        }
        if (this.c_intUnit != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: intUnit> ");
            }
            flag = true;
            stringbuffer.append("intUnit ");
            stringbuffer.append(this.c_intUnit);
        }
        if (this.c_elementNotThere != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: elementNotThere> ");
            }
            flag = true;
            stringbuffer.append("elementNotThere ");
            stringbuffer.append(this.c_elementNotThere);
        }
        if (this.c_elementEmpty != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: elementEmpty> ");
            }
            flag = true;
            stringbuffer.append("elementEmpty ");
            stringbuffer.append(this.c_elementEmpty);
        }
        if (this.c_noDataRequested != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: noDataRequested> ");
            }
            flag = true;
            stringbuffer.append("noDataRequested ");
            stringbuffer.append(this.c_noDataRequested);
        }
        if (this.c_diagnostic != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: diagnostic> ");
            }
            flag = true;
            stringbuffer.append("diagnostic ");
            stringbuffer.append(this.c_diagnostic);
        }
        if (this.c_subtree != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: subtree> ");
            }
            flag = true;
            stringbuffer.append("subtree ");
            stringbuffer.append("{");
            for (int i = 0; i < this.c_subtree.length; ++i) {
                stringbuffer.append(this.c_subtree[i]);
            }
            stringbuffer.append("}");
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

