/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_generic;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_generic.Variant_triples;

public final class Variant
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1ObjectIdentifier s_globalVariantSetId;
    public Variant_triples[] s_triples;

    public Variant() {
    }

    public Variant(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis Variant: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis Variant: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_globalVariantSetId = new ASN1ObjectIdentifier(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis Variant: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis Variant: bad tag in s_triples\n");
        }
        try {
            BERConstructed berconstructed1 = (BERConstructed)berencoding1;
            int k = berconstructed1.number_components();
            this.s_triples = new Variant_triples[k];
            for (int l = 0; l < k; ++l) {
                this.s_triples[l] = new Variant_triples(berconstructed1.elementAt(l), true);
            }
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Bad BER");
        }
        if (++j < i) {
            throw new ASN1Exception("Verbis Variant: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_globalVariantSetId != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_globalVariantSetId != null) {
            aberencoding[l++] = this.s_globalVariantSetId.ber_encode(128, 1);
        }
        BEREncoding[] aberencoding1 = new BEREncoding[this.s_triples.length];
        for (int i1 = 0; i1 < this.s_triples.length; ++i1) {
            aberencoding1[i1] = this.s_triples[i1].ber_encode();
        }
        aberencoding[l++] = new BERConstructed(128, 2, aberencoding1);
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_globalVariantSetId != null) {
            stringbuffer.append("globalVariantSetId ");
            stringbuffer.append(this.s_globalVariantSetId);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("triples ");
        stringbuffer.append("{");
        for (int i = 0; i < this.s_triples.length; ++i) {
            if (i != 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append(this.s_triples[i]);
        }
        stringbuffer.append("}");
        ++j;
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

