/*
 * Decompiled with CFR 0.152.
 */
package z3950.ResourceReport_FR2;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.ResourceReport_FR2.Estimate;
import z3950.v3.InternationalString;

public final class ResourceReport
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public Estimate[] s_estimates;
    public InternationalString s_message;

    public ResourceReport() {
    }

    public ResourceReport(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ResourceReport: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_estimates = null;
        this.s_message = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_estimates = new Estimate[k];
                for (int l = 0; l < k; ++l) {
                    this.s_estimates[l] = new Estimate(berconstructed1.elementAt(l), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_message = new InternationalString(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ResourceReport: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_estimates != null) {
            ++k;
        }
        if (this.s_message != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_estimates != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_estimates.length];
            for (int i1 = 0; i1 < this.s_estimates.length; ++i1) {
                aberencoding1[i1] = this.s_estimates[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 1, aberencoding1);
        }
        if (this.s_message != null) {
            aberencoding[l++] = this.s_message.ber_encode(128, 2);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_estimates != null) {
            stringbuffer.append("estimates ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_estimates.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_estimates[i]);
            }
            stringbuffer.append("}");
            ++j;
        }
        if (this.s_message != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("message ");
            stringbuffer.append(this.s_message);
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

