/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1Boolean;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.CompSpec_dbSpecific;
import z3950.v3.Specification;

public final class CompSpec
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1Boolean s_selectAlternativeSyntax;
    public Specification s_generic;
    public CompSpec_dbSpecific[] s_dbSpecific;
    public ASN1ObjectIdentifier[] s_recordSyntax;

    public CompSpec() {
    }

    public CompSpec(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis CompSpec: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis CompSpec: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis CompSpec: bad tag in s_selectAlternativeSyntax\n");
        }
        this.s_selectAlternativeSyntax = new ASN1Boolean(berencoding1, false);
        this.s_generic = null;
        this.s_dbSpecific = null;
        this.s_recordSyntax = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_generic = new Specification(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_dbSpecific = new CompSpec_dbSpecific[k];
                for (int i1 = 0; i1 < k; ++i1) {
                    this.s_dbSpecific[i1] = new CompSpec_dbSpecific(berconstructed1.elementAt(i1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed2 = (BERConstructed)berencoding1;
                int l = berconstructed2.number_components();
                this.s_recordSyntax = new ASN1ObjectIdentifier[l];
                for (int j1 = 0; j1 < l; ++j1) {
                    this.s_recordSyntax[j1] = new ASN1ObjectIdentifier(berconstructed2.elementAt(j1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis CompSpec: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_generic != null) {
            ++k;
        }
        if (this.s_dbSpecific != null) {
            ++k;
        }
        if (this.s_recordSyntax != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        aberencoding[l++] = this.s_selectAlternativeSyntax.ber_encode(128, 1);
        if (this.s_generic != null) {
            aberencoding[l++] = this.s_generic.ber_encode(128, 2);
        }
        if (this.s_dbSpecific != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_dbSpecific.length];
            for (int i1 = 0; i1 < this.s_dbSpecific.length; ++i1) {
                aberencoding1[i1] = this.s_dbSpecific[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 3, aberencoding1);
        }
        if (this.s_recordSyntax != null) {
            BEREncoding[] aberencoding2 = new BEREncoding[this.s_recordSyntax.length];
            for (int j1 = 0; j1 < this.s_recordSyntax.length; ++j1) {
                aberencoding2[j1] = this.s_recordSyntax[j1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 4, aberencoding2);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int k = 0;
        stringbuffer.append("selectAlternativeSyntax ");
        stringbuffer.append(this.s_selectAlternativeSyntax);
        ++k;
        if (this.s_generic != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("generic ");
            stringbuffer.append(this.s_generic);
            ++k;
        }
        if (this.s_dbSpecific != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("dbSpecific ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_dbSpecific.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_dbSpecific[i]);
            }
            stringbuffer.append("}");
            ++k;
        }
        if (this.s_recordSyntax != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("recordSyntax ");
            stringbuffer.append("{");
            for (int j = 0; j < this.s_recordSyntax.length; ++j) {
                if (j != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_recordSyntax[j]);
            }
            stringbuffer.append("}");
            ++k;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

