/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.OtherInformation;
import z3950.v3.ReferenceId;
import z3950.v3.ResultSetId;

public final class DeleteResultSetRequest
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ASN1Integer s_deleteFunction;
    public ResultSetId[] s_resultSetList;
    public OtherInformation s_otherInfo;
    public static final int E_list = 0;
    public static final int E_all = 1;

    public DeleteResultSetRequest() {
    }

    public DeleteResultSetRequest(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis DeleteResultSetRequest: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis DeleteResultSetRequest: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis DeleteResultSetRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 32 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis DeleteResultSetRequest: bad tag in s_deleteFunction\n");
        }
        this.s_deleteFunction = new ASN1Integer(berencoding1, false);
        this.s_resultSetList = null;
        this.s_otherInfo = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_resultSetList = new ResultSetId[k];
                for (int l = 0; l < k; ++l) {
                    this.s_resultSetList[l] = new ResultSetId(berconstructed1.elementAt(l), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_resultSetList = null;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis DeleteResultSetRequest: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_resultSetList != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        aberencoding[l++] = this.s_deleteFunction.ber_encode(128, 32);
        if (this.s_resultSetList != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_resultSetList.length];
            for (int i1 = 0; i1 < this.s_resultSetList.length; ++i1) {
                aberencoding1[i1] = this.s_resultSetList[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(0, 16, aberencoding1);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("deleteFunction ");
        stringbuffer.append(this.s_deleteFunction);
        ++j;
        if (this.s_resultSetList != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("resultSetList ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_resultSetList.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_resultSetList[i]);
            }
            stringbuffer.append("}");
            ++j;
        }
        if (this.s_otherInfo != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

