/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.DiagRec;
import z3950.v3.Entry;

public final class ListEntries
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public Entry[] s_entries;
    public DiagRec[] s_nonsurrogateDiagnostics;

    public ListEntries() {
    }

    public ListEntries(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ListEntries: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_entries = null;
        this.s_nonsurrogateDiagnostics = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_entries = new Entry[k];
                for (int i1 = 0; i1 < k; ++i1) {
                    this.s_entries[i1] = new Entry(berconstructed1.elementAt(i1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed2 = (BERConstructed)berencoding1;
                int l = berconstructed2.number_components();
                this.s_nonsurrogateDiagnostics = new DiagRec[l];
                for (int j1 = 0; j1 < l; ++j1) {
                    this.s_nonsurrogateDiagnostics[j1] = new DiagRec(berconstructed2.elementAt(j1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ListEntries: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_entries != null) {
            ++k;
        }
        if (this.s_nonsurrogateDiagnostics != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_entries != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_entries.length];
            for (int i1 = 0; i1 < this.s_entries.length; ++i1) {
                aberencoding1[i1] = this.s_entries[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 1, aberencoding1);
        }
        if (this.s_nonsurrogateDiagnostics != null) {
            BEREncoding[] aberencoding2 = new BEREncoding[this.s_nonsurrogateDiagnostics.length];
            for (int j1 = 0; j1 < this.s_nonsurrogateDiagnostics.length; ++j1) {
                aberencoding2[j1] = this.s_nonsurrogateDiagnostics[j1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 2, aberencoding2);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int k = 0;
        if (this.s_entries != null) {
            stringbuffer.append("entries ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_entries.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_entries[i]);
            }
            stringbuffer.append("}");
            ++k;
        }
        if (this.s_nonsurrogateDiagnostics != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("nonsurrogateDiagnostics ");
            stringbuffer.append("{");
            for (int j = 0; j < this.s_nonsurrogateDiagnostics.length; ++j) {
                if (j != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_nonsurrogateDiagnostics[j]);
            }
            stringbuffer.append("}");
            ++k;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

