/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BEREncoding;
import z3950.v3.AttributesPlusTerm;
import z3950.v3.ResultSetId;
import z3950.v3.ResultSetPlusAttributes;

public final class Operand
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public AttributesPlusTerm c_attrTerm;
    public ResultSetId c_resultSet;
    public ResultSetPlusAttributes c_resultAttr;

    public Operand() {
    }

    public Operand(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.ber_decode(berencoding, flag, encoding);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.c_attrTerm = null;
        this.c_resultSet = null;
        this.c_resultAttr = null;
        try {
            this.c_attrTerm = new AttributesPlusTerm(berencoding, flag, encoding);
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            try {
                this.c_resultSet = new ResultSetId(berencoding, flag);
                return;
            }
            catch (ASN1Exception aSN1Exception2) {
                try {
                    this.c_resultAttr = new ResultSetPlusAttributes(berencoding, flag);
                    return;
                }
                catch (ASN1Exception _ex) {
                    throw new ASN1Exception("Verbis Operand: bad BER encoding: choice not matched");
                }
            }
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding berencoding = null;
        if (this.c_attrTerm != null) {
            berencoding = this.c_attrTerm.ber_encode();
        }
        if (this.c_resultSet != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_resultSet.ber_encode();
        }
        if (this.c_resultAttr != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_resultAttr.ber_encode();
        }
        if (berencoding == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return berencoding;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis Operand: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_attrTerm != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: attrTerm> ");
            }
            flag = true;
            stringbuffer.append("attrTerm ");
            stringbuffer.append(this.c_attrTerm);
        }
        if (this.c_resultSet != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: resultSet> ");
            }
            flag = true;
            stringbuffer.append("resultSet ");
            stringbuffer.append(this.c_resultSet);
        }
        if (this.c_resultAttr != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: resultAttr> ");
            }
            flag = true;
            stringbuffer.append("resultAttr ");
            stringbuffer.append(this.c_resultAttr);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

