/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1OctetString;
import asn1.BERConstructed;
import asn1.BEREncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import z3950.v3.RPNQuery;

public final class Query
extends ASN1Any {
    private static final Logger logger = LoggerFactory.getLogger(Query.class);
    private String encoding;
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1Any c_type_0;
    public RPNQuery c_type_1;
    public ASN1OctetString c_type_2;
    public ASN1OctetString c_type_100;
    public RPNQuery c_type_101;
    public ASN1OctetString c_type_102;

    public Query(BEREncoding berEncoding, boolean flag, String encoding) throws ASN1Exception {
        this.ber_decode(berEncoding, flag, encoding);
    }

    public Query(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
        logger.warn("nevolat Query");
    }

    public Query() {
    }

    public void ber_decode(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.c_type_0 = null;
        this.c_type_1 = null;
        this.c_type_2 = null;
        this.c_type_100 = null;
        this.c_type_101 = null;
        this.c_type_102 = null;
        if (berencoding.tag_get() == 0 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed;
            try {
                berconstructed = (BERConstructed)berencoding;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis Query: bad BER form\n");
            }
            if (berconstructed.number_components() != 1) {
                throw new ASN1EncodingException("Verbis Query: bad BER form\n");
            }
            this.c_type_0 = new ASN1Any(berconstructed.elementAt(0), true);
            return;
        }
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            this.c_type_1 = new RPNQuery(berencoding, false, encoding);
            return;
        }
        if (berencoding.tag_get() == 2 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            try {
                berconstructed1 = (BERConstructed)berencoding;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis Query: bad BER form\n");
            }
            if (berconstructed1.number_components() != 1) {
                throw new ASN1EncodingException("Verbis Query: bad BER form\n");
            }
            this.c_type_2 = new ASN1OctetString(berconstructed1.elementAt(0), true);
            return;
        }
        if (berencoding.tag_get() == 100 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed2;
            try {
                berconstructed2 = (BERConstructed)berencoding;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis Query: bad BER form\n");
            }
            if (berconstructed2.number_components() != 1) {
                throw new ASN1EncodingException("Verbis Query: bad BER form\n");
            }
            this.c_type_100 = new ASN1OctetString(berconstructed2.elementAt(0), true);
            return;
        }
        if (berencoding.tag_get() == 101 && berencoding.tag_type_get() == 128) {
            this.c_type_101 = new RPNQuery(berencoding, false, encoding);
            return;
        }
        if (berencoding.tag_get() == 102 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed3;
            try {
                berconstructed3 = (BERConstructed)berencoding;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis Query: bad BER form\n");
            }
            if (berconstructed3.number_components() != 1) {
                throw new ASN1EncodingException("Verbis Query: bad BER form\n");
            }
            this.c_type_102 = new ASN1OctetString(berconstructed3.elementAt(0), true);
            return;
        }
        throw new ASN1Exception("Verbis Query: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding obj = null;
        if (this.c_type_0 != null) {
            BEREncoding[] aberencoding = new BEREncoding[]{this.c_type_0.ber_encode()};
            obj = new BERConstructed(128, 0, aberencoding);
        }
        if (this.c_type_1 != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_type_1.ber_encode(128, 1);
        }
        if (this.c_type_2 != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding1 = new BEREncoding[]{this.c_type_2.ber_encode()};
            obj = new BERConstructed(128, 2, aberencoding1);
        }
        if (this.c_type_100 != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding2 = new BEREncoding[]{this.c_type_100.ber_encode()};
            obj = new BERConstructed(128, 100, aberencoding2);
        }
        if (this.c_type_101 != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_type_101.ber_encode(128, 101);
        }
        if (this.c_type_102 != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding3 = new BEREncoding[]{this.c_type_102.ber_encode()};
            obj = new BERConstructed(128, 102, aberencoding3);
        }
        if (obj == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return obj;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis Query: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_type_0 != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: type-0> ");
            }
            flag = true;
            stringbuffer.append("type-0 ");
            stringbuffer.append(this.c_type_0);
        }
        if (this.c_type_1 != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: type-1> ");
            }
            flag = true;
            stringbuffer.append("type-1 ");
            stringbuffer.append(this.c_type_1);
        }
        if (this.c_type_2 != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: type-2> ");
            }
            flag = true;
            stringbuffer.append("type-2 ");
            stringbuffer.append(this.c_type_2);
        }
        if (this.c_type_100 != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: type-100> ");
            }
            flag = true;
            stringbuffer.append("type-100 ");
            stringbuffer.append(this.c_type_100);
        }
        if (this.c_type_101 != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: type-101> ");
            }
            flag = true;
            stringbuffer.append("type-101 ");
            stringbuffer.append(this.c_type_101);
        }
        if (this.c_type_102 != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: type-102> ");
            }
            flag = true;
            stringbuffer.append("type-102 ");
            stringbuffer.append(this.c_type_102);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

