/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.AttributeSetId;
import z3950.v3.RPNStructure;

public final class RPNQuery
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public AttributeSetId s_attributeSet;
    public RPNStructure s_rpn;

    public RPNQuery() {
    }

    public RPNQuery(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.ber_decode(berencoding, flag, encoding);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis RPNQuery: bad BER form\n");
        }
        int nrParts = berconstructed.number_components();
        int realNrParts = 0;
        if (nrParts <= realNrParts) {
            throw new ASN1Exception("Verbis RPNQuery: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(realNrParts);
        this.s_attributeSet = new AttributeSetId(berencoding1, true);
        if (nrParts <= ++realNrParts) {
            throw new ASN1Exception("Verbis RPNQuery: incomplete");
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        this.s_rpn = new RPNStructure(berencoding1, true, encoding);
        if (++realNrParts < nrParts) {
            throw new ASN1Exception("Verbis RPNQuery: bad BER: extra data " + realNrParts + "/" + nrParts + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int byte0 = 2;
        BEREncoding[] aberencoding = new BEREncoding[byte0];
        int k = 0;
        aberencoding[k++] = this.s_attributeSet.ber_encode();
        aberencoding[k++] = this.s_rpn.ber_encode();
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        stringbuffer.append("attributeSet ");
        stringbuffer.append(this.s_attributeSet);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("rpn ");
        stringbuffer.append(this.s_rpn);
        ++i;
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

