/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.DefaultDiagFormat;
import z3950.v3.DiagRec;
import z3950.v3.NamePlusRecord;

public final class Records
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public NamePlusRecord[] c_responseRecords;
    public DefaultDiagFormat c_nonSurrogateDiagnostic;
    public DiagRec[] c_multipleNonSurDiagnostics;

    public Records() {
    }

    public Records(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_responseRecords = null;
        this.c_nonSurrogateDiagnostic = null;
        this.c_multipleNonSurDiagnostics = null;
        if (berencoding.tag_get() == 28 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed;
            BEREncoding berencoding1 = berencoding;
            try {
                berconstructed = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis Records: bad BER form\n");
            }
            int i = berconstructed.number_components();
            this.c_responseRecords = new NamePlusRecord[i];
            for (int k = 0; k < i; ++k) {
                this.c_responseRecords[k] = new NamePlusRecord(berconstructed.elementAt(k), true);
            }
            return;
        }
        if (berencoding.tag_get() == 130 && berencoding.tag_type_get() == 128) {
            this.c_nonSurrogateDiagnostic = new DefaultDiagFormat(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 205 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            BEREncoding berencoding2 = berencoding;
            try {
                berconstructed1 = (BERConstructed)berencoding2;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis Records: bad BER form\n");
            }
            int j = berconstructed1.number_components();
            this.c_multipleNonSurDiagnostics = new DiagRec[j];
            for (int l = 0; l < j; ++l) {
                this.c_multipleNonSurDiagnostics[l] = new DiagRec(berconstructed1.elementAt(l), true);
            }
            return;
        }
        throw new ASN1Exception("Verbis Records: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding obj = null;
        if (this.c_responseRecords != null) {
            BEREncoding[] aberencoding = new BEREncoding[this.c_responseRecords.length];
            for (int i = 0; i < this.c_responseRecords.length; ++i) {
                aberencoding[i] = this.c_responseRecords[i].ber_encode();
            }
            obj = new BERConstructed(128, 28, aberencoding);
        }
        if (this.c_nonSurrogateDiagnostic != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_nonSurrogateDiagnostic.ber_encode(128, 130);
        }
        if (this.c_multipleNonSurDiagnostics != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding1 = new BEREncoding[this.c_multipleNonSurDiagnostics.length];
            for (int j = 0; j < this.c_multipleNonSurDiagnostics.length; ++j) {
                aberencoding1[j] = this.c_multipleNonSurDiagnostics[j].ber_encode();
            }
            obj = new BERConstructed(128, 205, aberencoding1);
        }
        if (obj == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return obj;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis Records: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_responseRecords != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: responseRecords> ");
            }
            flag = true;
            stringbuffer.append("responseRecords ");
            stringbuffer.append("{");
            for (int i = 0; i < this.c_responseRecords.length; ++i) {
                stringbuffer.append(this.c_responseRecords[i]);
            }
            stringbuffer.append("}");
        }
        if (this.c_nonSurrogateDiagnostic != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: nonSurrogateDiagnostic> ");
            }
            flag = true;
            stringbuffer.append("nonSurrogateDiagnostic ");
            stringbuffer.append(this.c_nonSurrogateDiagnostic);
        }
        if (this.c_multipleNonSurDiagnostics != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: multipleNonSurDiagnostics> ");
            }
            flag = true;
            stringbuffer.append("multipleNonSurDiagnostics ");
            stringbuffer.append("{");
            for (int j = 0; j < this.c_multipleNonSurDiagnostics.length; ++j) {
                stringbuffer.append(this.c_multipleNonSurDiagnostics[j]);
            }
            stringbuffer.append("}");
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

