/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.OtherInformation;
import z3950.v3.ReferenceId;
import z3950.v3.ResourceReport;

public final class ResourceReportResponse
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ASN1Integer s_resourceReportStatus;
    public ResourceReport s_resourceReport;
    public OtherInformation s_otherInfo;
    public static final int E_success = 0;
    public static final int E_partial = 1;
    public static final int E_failure_1 = 2;
    public static final int E_failure_2 = 3;
    public static final int E_failure_3 = 4;
    public static final int E_failure_4 = 5;
    public static final int E_failure_5 = 6;
    public static final int E_failure_6 = 7;

    public ResourceReportResponse() {
    }

    public ResourceReportResponse(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ResourceReportResponse: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis ResourceReportResponse: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ResourceReportResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 50 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ResourceReportResponse: bad tag in s_resourceReportStatus\n");
        }
        this.s_resourceReportStatus = new ASN1Integer(berencoding1, false);
        this.s_resourceReport = null;
        this.s_otherInfo = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 51 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            try {
                berconstructed1 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis ResourceReportResponse: bad BER encoding: s_resourceReport tag bad\n");
            }
            if (berconstructed1.number_components() != 1) {
                throw new ASN1EncodingException("Verbis ResourceReportResponse: bad BER encoding: s_resourceReport tag bad\n");
            }
            this.s_resourceReport = new ResourceReport(berconstructed1.elementAt(0), true);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ResourceReportResponse: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_resourceReport != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        aberencoding[l++] = this.s_resourceReportStatus.ber_encode(128, 50);
        if (this.s_resourceReport != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[]{this.s_resourceReport.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 51, aberencoding1);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("resourceReportStatus ");
        stringbuffer.append(this.s_resourceReportStatus);
        ++i;
        if (this.s_resourceReport != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("resourceReport ");
            stringbuffer.append(this.s_resourceReport);
            ++i;
        }
        if (this.s_otherInfo != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

