/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.AttributeSetId;
import z3950.v3.AttributesPlusTerm;
import z3950.v3.DatabaseName;
import z3950.v3.OtherInformation;
import z3950.v3.ReferenceId;

public final class ScanRequest
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public DatabaseName[] s_databaseNames;
    public AttributeSetId s_attributeSet;
    public AttributesPlusTerm s_termListAndStartPoint;
    public ASN1Integer s_stepSize;
    public ASN1Integer s_numberOfTermsRequested;
    public ASN1Integer s_preferredPositionInResponse;
    public OtherInformation s_otherInfo;

    public ScanRequest() {
    }

    public ScanRequest(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ScanRequest: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis ScanRequest: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ScanRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 3 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ScanRequest: bad tag in s_databaseNames\n");
        }
        try {
            BERConstructed berconstructed1 = (BERConstructed)berencoding1;
            int k = berconstructed1.number_components();
            this.s_databaseNames = new DatabaseName[k];
            for (int l = 0; l < k; ++l) {
                this.s_databaseNames[l] = new DatabaseName(berconstructed1.elementAt(l), true);
            }
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Bad BER");
        }
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ScanRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_attributeSet = new AttributeSetId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_attributeSet = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ScanRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        this.s_termListAndStartPoint = new AttributesPlusTerm(berencoding1, true);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ScanRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 5 && berencoding1.tag_type_get() == 128) {
            this.s_stepSize = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ScanRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 6 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ScanRequest: bad tag in s_numberOfTermsRequested\n");
        }
        this.s_numberOfTermsRequested = new ASN1Integer(berencoding1, false);
        this.s_preferredPositionInResponse = null;
        this.s_otherInfo = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 7 && berencoding1.tag_type_get() == 128) {
            this.s_preferredPositionInResponse = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ScanRequest: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 3;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_attributeSet != null) {
            ++k;
        }
        if (this.s_stepSize != null) {
            ++k;
        }
        if (this.s_preferredPositionInResponse != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        BEREncoding[] aberencoding1 = new BEREncoding[this.s_databaseNames.length];
        for (int i1 = 0; i1 < this.s_databaseNames.length; ++i1) {
            aberencoding1[i1] = this.s_databaseNames[i1].ber_encode();
        }
        aberencoding[l++] = new BERConstructed(128, 3, aberencoding1);
        if (this.s_attributeSet != null) {
            aberencoding[l++] = this.s_attributeSet.ber_encode();
        }
        aberencoding[l++] = this.s_termListAndStartPoint.ber_encode();
        if (this.s_stepSize != null) {
            aberencoding[l++] = this.s_stepSize.ber_encode(128, 5);
        }
        aberencoding[l++] = this.s_numberOfTermsRequested.ber_encode(128, 6);
        if (this.s_preferredPositionInResponse != null) {
            aberencoding[l++] = this.s_preferredPositionInResponse.ber_encode(128, 7);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("databaseNames ");
        stringbuffer.append("{");
        for (int i = 0; i < this.s_databaseNames.length; ++i) {
            if (i != 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append(this.s_databaseNames[i]);
        }
        stringbuffer.append("}");
        ++j;
        if (this.s_attributeSet != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("attributeSet ");
            stringbuffer.append(this.s_attributeSet);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("termListAndStartPoint ");
        stringbuffer.append(this.s_termListAndStartPoint);
        ++j;
        if (this.s_stepSize != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("stepSize ");
            stringbuffer.append(this.s_stepSize);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("numberOfTermsRequested ");
        stringbuffer.append(this.s_numberOfTermsRequested);
        ++j;
        if (this.s_preferredPositionInResponse != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("preferredPositionInResponse ");
            stringbuffer.append(this.s_preferredPositionInResponse);
            ++j;
        }
        if (this.s_otherInfo != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

