/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.AttributeSetId;
import z3950.v3.ListEntries;
import z3950.v3.OtherInformation;
import z3950.v3.ReferenceId;

public final class ScanResponse
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ASN1Integer s_stepSize;
    public ASN1Integer s_scanStatus;
    public ASN1Integer s_numberOfEntriesReturned;
    public ASN1Integer s_positionOfTerm;
    public ListEntries s_entries;
    public AttributeSetId s_attributeSet;
    public OtherInformation s_otherInfo;
    public static final int E_success = 0;
    public static final int E_partial_1 = 1;
    public static final int E_partial_2 = 2;
    public static final int E_partial_3 = 3;
    public static final int E_partial_4 = 4;
    public static final int E_partial_5 = 5;
    public static final int E_failure = 6;

    public ScanResponse() {
    }

    public ScanResponse(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ScanResponse: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis ScanResponse: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ScanResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_stepSize = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ScanResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 4 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ScanResponse: bad tag in s_scanStatus\n");
        }
        this.s_scanStatus = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ScanResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 5 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ScanResponse: bad tag in s_numberOfEntriesReturned\n");
        }
        this.s_numberOfEntriesReturned = new ASN1Integer(berencoding1, false);
        this.s_positionOfTerm = null;
        this.s_entries = null;
        this.s_attributeSet = null;
        this.s_otherInfo = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 6 && berencoding1.tag_type_get() == 128) {
            this.s_positionOfTerm = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 7 && berencoding1.tag_type_get() == 128) {
            this.s_entries = new ListEntries(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 8 && berencoding1.tag_type_get() == 128) {
            this.s_attributeSet = new AttributeSetId(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ScanResponse: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_stepSize != null) {
            ++k;
        }
        if (this.s_positionOfTerm != null) {
            ++k;
        }
        if (this.s_entries != null) {
            ++k;
        }
        if (this.s_attributeSet != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        if (this.s_stepSize != null) {
            aberencoding[l++] = this.s_stepSize.ber_encode(128, 3);
        }
        aberencoding[l++] = this.s_scanStatus.ber_encode(128, 4);
        aberencoding[l++] = this.s_numberOfEntriesReturned.ber_encode(128, 5);
        if (this.s_positionOfTerm != null) {
            aberencoding[l++] = this.s_positionOfTerm.ber_encode(128, 6);
        }
        if (this.s_entries != null) {
            aberencoding[l++] = this.s_entries.ber_encode(128, 7);
        }
        if (this.s_attributeSet != null) {
            aberencoding[l++] = this.s_attributeSet.ber_encode(128, 8);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++i;
        }
        if (this.s_stepSize != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("stepSize ");
            stringbuffer.append(this.s_stepSize);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("scanStatus ");
        stringbuffer.append(this.s_scanStatus);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("numberOfEntriesReturned ");
        stringbuffer.append(this.s_numberOfEntriesReturned);
        ++i;
        if (this.s_positionOfTerm != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("positionOfTerm ");
            stringbuffer.append(this.s_positionOfTerm);
            ++i;
        }
        if (this.s_entries != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("entries ");
            stringbuffer.append(this.s_entries);
            ++i;
        }
        if (this.s_attributeSet != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("attributeSet ");
            stringbuffer.append(this.s_attributeSet);
            ++i;
        }
        if (this.s_otherInfo != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

