/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1Boolean;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import cz.kpsys.kpwinsql.z3950.model.ZServerDatabaseConfig;
import cz.kpsys.kpwinsql.z3950.services.ZServerConfigService;
import z3950.v3.DatabaseName;
import z3950.v3.ElementSetNames;
import z3950.v3.InternationalString;
import z3950.v3.OtherInformation;
import z3950.v3.Query;
import z3950.v3.ReferenceId;

public final class SearchRequest
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ASN1Integer s_smallSetUpperBound;
    public ASN1Integer s_largeSetLowerBound;
    public ASN1Integer s_mediumSetPresentNumber;
    public ASN1Boolean s_replaceIndicator;
    public InternationalString s_resultSetName;
    public DatabaseName[] s_databaseNames;
    public ElementSetNames s_smallSetElementSetNames;
    public ElementSetNames s_mediumSetElementSetNames;
    public ASN1ObjectIdentifier s_preferredRecordSyntax;
    public Query s_query;
    public OtherInformation s_additionalSearchInfo;
    public OtherInformation s_otherInfo;

    public SearchRequest() {
    }

    public SearchRequest(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed3;
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis SearchRequest: bad BER form\n");
        }
        int nrParts = berconstructed.number_components();
        int realNrParts = 0;
        if (nrParts <= realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(realNrParts);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++realNrParts;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (nrParts <= realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() != 13 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SearchRequest: bad tag in s_smallSetUpperBound\n");
        }
        this.s_smallSetUpperBound = new ASN1Integer(berencoding1, false);
        if (nrParts <= ++realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() != 14 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SearchRequest: bad tag in s_largeSetLowerBound\n");
        }
        this.s_largeSetLowerBound = new ASN1Integer(berencoding1, false);
        if (nrParts <= ++realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() != 15 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SearchRequest: bad tag in s_mediumSetPresentNumber\n");
        }
        this.s_mediumSetPresentNumber = new ASN1Integer(berencoding1, false);
        if (nrParts <= ++realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() != 16 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SearchRequest: bad tag in s_replaceIndicator\n");
        }
        this.s_replaceIndicator = new ASN1Boolean(berencoding1, false);
        if (nrParts <= ++realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() != 17 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SearchRequest: bad tag in s_resultSetName\n");
        }
        this.s_resultSetName = new InternationalString(berencoding1, false);
        if (nrParts <= ++realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() != 18 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SearchRequest: bad tag in s_databaseNames\n");
        }
        try {
            BERConstructed berconstructed4 = (BERConstructed)berencoding1;
            int k = berconstructed4.number_components();
            this.s_databaseNames = new DatabaseName[k];
            for (int l = 0; l < k; ++l) {
                this.s_databaseNames[l] = new DatabaseName(berconstructed4.elementAt(l), true);
            }
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Bad BER");
        }
        if (nrParts <= ++realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        String encoding = this.zjistiKodovaniPodleDb(this.s_databaseNames);
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() == 100 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            try {
                berconstructed1 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis SearchRequest: bad BER encoding: s_smallSetElementSetNames tag bad\n");
            }
            if (berconstructed1.number_components() != 1) {
                throw new ASN1EncodingException("Verbis SearchRequest: bad BER encoding: s_smallSetElementSetNames tag bad\n");
            }
            this.s_smallSetElementSetNames = new ElementSetNames(berconstructed1.elementAt(0), true);
            ++realNrParts;
        }
        if (nrParts <= realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() == 101 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed2;
            try {
                berconstructed2 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis SearchRequest: bad BER encoding: s_mediumSetElementSetNames tag bad\n");
            }
            if (berconstructed2.number_components() != 1) {
                throw new ASN1EncodingException("Verbis SearchRequest: bad BER encoding: s_mediumSetElementSetNames tag bad\n");
            }
            this.s_mediumSetElementSetNames = new ElementSetNames(berconstructed2.elementAt(0), true);
            ++realNrParts;
        }
        if (nrParts <= realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() == 104 && berencoding1.tag_type_get() == 128) {
            this.s_preferredRecordSyntax = new ASN1ObjectIdentifier(berencoding1, false);
            ++realNrParts;
        }
        if (nrParts <= realNrParts) {
            throw new ASN1Exception("Verbis SearchRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() != 21 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SearchRequest: bad tag in s_query\n");
        }
        try {
            berconstructed3 = (BERConstructed)berencoding1;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis SearchRequest: bad BER encoding: s_query tag bad\n");
        }
        if (berconstructed3.number_components() != 1) {
            throw new ASN1EncodingException("Verbis SearchRequest: bad BER encoding: s_query tag bad\n");
        }
        this.s_query = new Query(berconstructed3.elementAt(0), true, encoding);
        this.s_additionalSearchInfo = null;
        this.s_otherInfo = null;
        if (nrParts <= ++realNrParts) {
            return;
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        if (berencoding1.tag_get() == 203 && berencoding1.tag_type_get() == 128) {
            this.s_additionalSearchInfo = new OtherInformation(berencoding1, false);
            ++realNrParts;
        }
        if (nrParts <= realNrParts) {
            return;
        }
        berencoding1 = berconstructed.elementAt(realNrParts);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++realNrParts;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (realNrParts < nrParts) {
            throw new ASN1Exception("Verbis SearchRequest: bad BER: extra data " + realNrParts + "/" + nrParts + " processed");
        }
    }

    private String zjistiKodovaniPodleDb(DatabaseName[] dbNames) {
        if (dbNames == null || dbNames.length == 0) {
            return ZServerConfigService.getServerConfig().getEncoding();
        }
        DatabaseName dbName = dbNames[0];
        ZServerDatabaseConfig config = (ZServerDatabaseConfig)ZServerConfigService.getServerConfig().getDatabases().get(dbName.value.toString().replace("\"", "").toUpperCase());
        if (config != null) {
            return config.getEncoding();
        }
        return "ASCII";
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 7;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_smallSetElementSetNames != null) {
            ++k;
        }
        if (this.s_mediumSetElementSetNames != null) {
            ++k;
        }
        if (this.s_preferredRecordSyntax != null) {
            ++k;
        }
        if (this.s_additionalSearchInfo != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        aberencoding[l++] = this.s_smallSetUpperBound.ber_encode(128, 13);
        aberencoding[l++] = this.s_largeSetLowerBound.ber_encode(128, 14);
        aberencoding[l++] = this.s_mediumSetPresentNumber.ber_encode(128, 15);
        aberencoding[l++] = this.s_replaceIndicator.ber_encode(128, 16);
        aberencoding[l++] = this.s_resultSetName.ber_encode(128, 17);
        BEREncoding[] aberencoding1 = new BEREncoding[this.s_databaseNames.length];
        for (int i1 = 0; i1 < this.s_databaseNames.length; ++i1) {
            aberencoding1[i1] = this.s_databaseNames[i1].ber_encode();
        }
        aberencoding[l++] = new BERConstructed(128, 18, aberencoding1);
        if (this.s_smallSetElementSetNames != null) {
            BEREncoding[] aberencoding2 = new BEREncoding[]{this.s_smallSetElementSetNames.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 100, aberencoding2);
        }
        if (this.s_mediumSetElementSetNames != null) {
            BEREncoding[] aberencoding3 = new BEREncoding[]{this.s_mediumSetElementSetNames.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 101, aberencoding3);
        }
        if (this.s_preferredRecordSyntax != null) {
            aberencoding[l++] = this.s_preferredRecordSyntax.ber_encode(128, 104);
        }
        BEREncoding[] aberencoding4 = new BEREncoding[]{this.s_query.ber_encode()};
        aberencoding[l++] = new BERConstructed(128, 21, aberencoding4);
        if (this.s_additionalSearchInfo != null) {
            aberencoding[l++] = this.s_additionalSearchInfo.ber_encode(128, 203);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("smallSetUpperBound ");
        stringbuffer.append(this.s_smallSetUpperBound);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("largeSetLowerBound ");
        stringbuffer.append(this.s_largeSetLowerBound);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("mediumSetPresentNumber ");
        stringbuffer.append(this.s_mediumSetPresentNumber);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("replaceIndicator ");
        stringbuffer.append(this.s_replaceIndicator);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("resultSetName ");
        stringbuffer.append(this.s_resultSetName);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("databaseNames ");
        stringbuffer.append("{");
        for (int i = 0; i < this.s_databaseNames.length; ++i) {
            if (i != 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append(this.s_databaseNames[i]);
        }
        stringbuffer.append("}");
        ++j;
        if (this.s_smallSetElementSetNames != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("smallSetElementSetNames ");
            stringbuffer.append(this.s_smallSetElementSetNames);
            ++j;
        }
        if (this.s_mediumSetElementSetNames != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("mediumSetElementSetNames ");
            stringbuffer.append(this.s_mediumSetElementSetNames);
            ++j;
        }
        if (this.s_preferredRecordSyntax != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("preferredRecordSyntax ");
            stringbuffer.append(this.s_preferredRecordSyntax);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("query ");
        stringbuffer.append(this.s_query);
        ++j;
        if (this.s_additionalSearchInfo != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("additionalSearchInfo ");
            stringbuffer.append(this.s_additionalSearchInfo);
            ++j;
        }
        if (this.s_otherInfo != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

