/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.NamePlusRecord;
import z3950.v3.OtherInformation;
import z3950.v3.ReferenceId;

public final class Segment
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ASN1Integer s_numberOfRecordsReturned;
    public NamePlusRecord[] s_segmentRecords;
    public OtherInformation s_otherInfo;

    public Segment() {
    }

    public Segment(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis Segment: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis Segment: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis Segment: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 24 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis Segment: bad tag in s_numberOfRecordsReturned\n");
        }
        this.s_numberOfRecordsReturned = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis Segment: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 0 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis Segment: bad tag in s_segmentRecords\n");
        }
        try {
            BERConstructed berconstructed1 = (BERConstructed)berencoding1;
            int k = berconstructed1.number_components();
            this.s_segmentRecords = new NamePlusRecord[k];
            for (int l = 0; l < k; ++l) {
                this.s_segmentRecords[l] = new NamePlusRecord(berconstructed1.elementAt(l), true);
            }
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Bad BER");
        }
        this.s_otherInfo = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis Segment: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        aberencoding[l++] = this.s_numberOfRecordsReturned.ber_encode(128, 24);
        BEREncoding[] aberencoding1 = new BEREncoding[this.s_segmentRecords.length];
        for (int i1 = 0; i1 < this.s_segmentRecords.length; ++i1) {
            aberencoding1[i1] = this.s_segmentRecords[i1].ber_encode();
        }
        aberencoding[l++] = new BERConstructed(128, 0, aberencoding1);
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("numberOfRecordsReturned ");
        stringbuffer.append(this.s_numberOfRecordsReturned);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("segmentRecords ");
        stringbuffer.append("{");
        for (int i = 0; i < this.s_segmentRecords.length; ++i) {
            if (i != 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append(this.s_segmentRecords[i]);
        }
        stringbuffer.append("}");
        ++j;
        if (this.s_otherInfo != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

