/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.InternationalString;
import z3950.v3.OtherInformation;
import z3950.v3.ReferenceId;
import z3950.v3.SortKeySpec;

public final class SortRequest
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public InternationalString[] s_inputResultSetNames;
    public InternationalString s_sortedResultSetName;
    public SortKeySpec[] s_sortSequence;
    public OtherInformation s_otherInfo;

    public SortRequest() {
    }

    public SortRequest(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis SortRequest: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis SortRequest: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis SortRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 3 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SortRequest: bad tag in s_inputResultSetNames\n");
        }
        try {
            BERConstructed berconstructed1 = (BERConstructed)berencoding1;
            int k = berconstructed1.number_components();
            this.s_inputResultSetNames = new InternationalString[k];
            for (int i1 = 0; i1 < k; ++i1) {
                this.s_inputResultSetNames[i1] = new InternationalString(berconstructed1.elementAt(i1), true);
            }
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Bad BER");
        }
        if (i <= ++j) {
            throw new ASN1Exception("Verbis SortRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 4 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SortRequest: bad tag in s_sortedResultSetName\n");
        }
        this.s_sortedResultSetName = new InternationalString(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis SortRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 5 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SortRequest: bad tag in s_sortSequence\n");
        }
        try {
            BERConstructed berconstructed2 = (BERConstructed)berencoding1;
            int l = berconstructed2.number_components();
            this.s_sortSequence = new SortKeySpec[l];
            for (int j1 = 0; j1 < l; ++j1) {
                this.s_sortSequence[j1] = new SortKeySpec(berconstructed2.elementAt(j1), true);
            }
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Bad BER");
        }
        this.s_otherInfo = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis SortRequest: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 3;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        BEREncoding[] aberencoding1 = new BEREncoding[this.s_inputResultSetNames.length];
        for (int i1 = 0; i1 < this.s_inputResultSetNames.length; ++i1) {
            aberencoding1[i1] = this.s_inputResultSetNames[i1].ber_encode();
        }
        aberencoding[l++] = new BERConstructed(128, 3, aberencoding1);
        aberencoding[l++] = this.s_sortedResultSetName.ber_encode(128, 4);
        aberencoding1 = new BEREncoding[this.s_sortSequence.length];
        for (int j1 = 0; j1 < this.s_sortSequence.length; ++j1) {
            aberencoding1[j1] = this.s_sortSequence[j1].ber_encode();
        }
        aberencoding[l++] = new BERConstructed(128, 5, aberencoding1);
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int k = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++k;
        }
        if (k > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("inputResultSetNames ");
        stringbuffer.append("{");
        for (int i = 0; i < this.s_inputResultSetNames.length; ++i) {
            if (i != 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append(this.s_inputResultSetNames[i]);
        }
        stringbuffer.append("}");
        if (++k > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("sortedResultSetName ");
        stringbuffer.append(this.s_sortedResultSetName);
        if (++k > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("sortSequence ");
        stringbuffer.append("{");
        for (int j = 0; j < this.s_sortSequence.length; ++j) {
            if (j != 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append(this.s_sortSequence[j]);
        }
        stringbuffer.append("}");
        ++k;
        if (this.s_otherInfo != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++k;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

