/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1GeneralizedTime;
import asn1.ASN1Integer;
import asn1.ASN1Null;
import asn1.ASN1ObjectIdentifier;
import asn1.ASN1OctetString;
import asn1.BEREncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import z3950.v3.IntUnit;
import z3950.v3.InternationalString;

public final class Term
extends ASN1Any {
    private static final Logger logger = LoggerFactory.getLogger(Term.class);
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1OctetString c_general;
    public ASN1Integer c_numeric;
    public InternationalString c_characterString;
    public ASN1ObjectIdentifier c_oid;
    public ASN1GeneralizedTime c_dateTime;
    public ASN1External c_external;
    public IntUnit c_integerAndUnit;
    public ASN1Null c_null;

    public Term() {
    }

    public Term(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        logger.warn("nevolat!");
    }

    public Term(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.ber_decode(berencoding, flag, encoding);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.c_general = null;
        this.c_numeric = null;
        this.c_characterString = null;
        this.c_oid = null;
        this.c_dateTime = null;
        this.c_external = null;
        this.c_integerAndUnit = null;
        this.c_null = null;
        if (berencoding.tag_get() == 45 && berencoding.tag_type_get() == 128) {
            this.c_general = new ASN1OctetString(berencoding, false, encoding);
            return;
        }
        if (berencoding.tag_get() == 215 && berencoding.tag_type_get() == 128) {
            this.c_numeric = new ASN1Integer(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 216 && berencoding.tag_type_get() == 128) {
            this.c_characterString = new InternationalString(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 217 && berencoding.tag_type_get() == 128) {
            this.c_oid = new ASN1ObjectIdentifier(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 218 && berencoding.tag_type_get() == 128) {
            this.c_dateTime = new ASN1GeneralizedTime(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 219 && berencoding.tag_type_get() == 128) {
            this.c_external = new ASN1External(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 220 && berencoding.tag_type_get() == 128) {
            this.c_integerAndUnit = new IntUnit(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 221 && berencoding.tag_type_get() == 128) {
            this.c_null = new ASN1Null(berencoding, false);
            return;
        }
        throw new ASN1Exception("Verbis Term: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding berencoding = null;
        if (this.c_general != null) {
            berencoding = this.c_general.ber_encode(128, 45);
        }
        if (this.c_numeric != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_numeric.ber_encode(128, 215);
        }
        if (this.c_characterString != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_characterString.ber_encode(128, 216);
        }
        if (this.c_oid != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_oid.ber_encode(128, 217);
        }
        if (this.c_dateTime != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_dateTime.ber_encode(128, 218);
        }
        if (this.c_external != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_external.ber_encode(128, 219);
        }
        if (this.c_integerAndUnit != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_integerAndUnit.ber_encode(128, 220);
        }
        if (this.c_null != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_null.ber_encode(128, 221);
        }
        if (berencoding == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return berencoding;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis Term: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_general != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: general> ");
            }
            flag = true;
            stringbuffer.append("general ");
            stringbuffer.append(this.c_general);
        }
        if (this.c_numeric != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: numeric> ");
            }
            flag = true;
            stringbuffer.append("numeric ");
            stringbuffer.append(this.c_numeric);
        }
        if (this.c_characterString != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: characterString> ");
            }
            flag = true;
            stringbuffer.append("characterString ");
            stringbuffer.append(this.c_characterString);
        }
        if (this.c_oid != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: oid> ");
            }
            flag = true;
            stringbuffer.append("oid ");
            stringbuffer.append(this.c_oid);
        }
        if (this.c_dateTime != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: dateTime> ");
            }
            flag = true;
            stringbuffer.append("dateTime ");
            stringbuffer.append(this.c_dateTime);
        }
        if (this.c_external != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: external> ");
            }
            flag = true;
            stringbuffer.append("external ");
            stringbuffer.append(this.c_external);
        }
        if (this.c_integerAndUnit != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: integerAndUnit> ");
            }
            flag = true;
            stringbuffer.append("integerAndUnit ");
            stringbuffer.append(this.c_integerAndUnit);
        }
        if (this.c_null != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: null> ");
            }
            flag = true;
            stringbuffer.append("null ");
            stringbuffer.append(this.c_null);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

